package com.aote.path;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Map;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;

@Component
public class PathServer {
	static Logger log = Logger.getLogger(PathServer.class);

	@Autowired
	public SessionFactory sessionFactory;
	
	public SessionFactory getSessionFactory() {
		return sessionFactory;
	}
	
	public Session assignedSession;

	public void setAssignedSession(Session session) {
		this.assignedSession = session;
	}

	/**
	 * 执行一条path查询
	 * @param name path名称
	 * @param str 参数
	 * @return
	 */
	public JSONArray query(String name, String str) {
		try {
			// 获取参数
			JSONObject param = null;
			if (str != null && !str.isEmpty()) {
				JSONObject json = new JSONObject(str);
				if (json.has("data")) {
					param = json.getJSONObject("data");
				}
			}
			Map<String, Object> params = JsonHelper.toMap(param);
			// 产生path语句编译后的结果
			String path = this.call(name, params);
	
			Session session = (assignedSession==null ? sessionFactory.getCurrentSession() : assignedSession);
			JSONArray array = PathHelper.query(session, path);
			return array;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 获取path查询的总和
	 * @param name path查询
	 * @param str path参数
	 * @return 查询结果
	 * @throws Exception
	 */
	public JSONObject queryTotal(String name, String str) throws Exception {
		// 获取参数
		JSONObject param = null;
		if (str != null && !str.isEmpty()) {
			JSONObject json = new JSONObject(str);
			if (json.has("data")) {
				param = json.getJSONObject("data");
			}
		}
		Map<String, Object> params = JsonHelper.toMap(param);
		// 产生path语句编译后的结果
		String path = this.call(name, params);

		// 对path进行处理，只查最上层的总和
		path = filterOutOrderBy(path);
		Session session = (assignedSession==null ? sessionFactory.getCurrentSession() : assignedSession);
		JSONArray array = PathHelper.query(session, path);
		return array.getJSONObject(0);
	}

	public JSONArray query(String name, int pageNo, int pageSize, String str)
			throws Exception {
		// pageNo小于0， 纠正成1
		if (pageNo <= 0) {
			pageNo = 1;
		}

		// pageSize小于0，纠正成1, 解除1000限制
		if (pageSize < 1) {
			pageSize = 1000;
		}

		// 拿到json对象参数
		JSONObject param = null;
		if (str != null && !str.isEmpty()) {
			param = new JSONObject(str);
			param = param.getJSONObject("data");
		}
		Map<String, Object> params = JsonHelper.toMap(param);
		return query(name, pageNo, pageSize, params);
	}

	public JSONArray query(String name, int pageNo, int pageSize,
			Map<String, Object> params) throws Exception {
		// 产生SQL语句编译后的结果
		String sql = this.call(name, params);

		Session session = (assignedSession==null ? sessionFactory.getCurrentSession() : assignedSession);
		JSONArray array = PathHelper.query(session, sql, pageNo - 1, pageSize);
		log.debug(array.toString());
		return array;
	}

	// 调用其它sql语句, 产生sql语句经过参数处理的结果串
	public String call(String name, Map<String, Object> params) {
		// 获取原始sql语句
		String path = PathMapper.getPath(name);
		String sql = ResourceHelper.getString(path);

		// 获取编译后的sql语句
		sql = sql.replace("\r\n", "\n");
		sql = "$" + sql;
		// 把自身注册到执行环境中
		params.put("sql", this);
		sql = ExpressionHelper.run(sql, params).toString();

		return sql;
	}
	
	// 对path路径进行过滤，改变成查总数的形式
	private String filterOutOrderBy(String source) {
		// 读取第一行数据
		BufferedReader reader = new BufferedReader(new StringReader(source));
		try {
			String line = reader.readLine();
			reader.close();
			// 去掉最后的'(', 添加'.count(*)'求和
			int index = line.lastIndexOf('.');
			String result = line.substring(0, index) + ".(count(*) n, group(null))";
			return result;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	// 执行业务逻辑中内嵌的path语句
	public JSONArray query(String sql) {
		Session session = (assignedSession==null ? sessionFactory.getCurrentSession() : assignedSession);
		try {
			return PathHelper.query(session, sql);
		} catch(RuntimeException e) {
			throw e;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
}
