package com.aote.path;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/**
 * path映射器
 * 
 * @author HNS
 *
 */
public class PathMapper {

	static Logger log = Logger.getLogger(PathMapper.class);

	private static Map<String, Map<String, String>> map;

	public static synchronized String getPath(String alias) {
		if (map == null)
			loadMap();
		if (map.containsKey(alias))
			return map.get(alias).get("path");
		else
			return null;
	}

	public static synchronized String getAttr(String alias, String name) {
		if (map == null)
			loadMap();
		if (map.containsKey(alias))
			return map.get(alias).get(name);
		else
			return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<String, Map<String,String>>();

		SAXReader reader = new SAXReader();
		InputStream module = PathMapper.class.getClassLoader()
				.getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = PathMapper.class.getClassLoader()
					.getResourceAsStream("path.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator it = root.elementIterator("path"); it.hasNext();) {
					Element elm = (Element) it.next();
					// 设置业务逻辑属性
					Map<String, String> logic = new HashMap<String, String>();
					String alias = elm.attribute("alias").getValue();
					logic.put("alias", alias);
					String path = elm.attribute("path").getValue();
					logic.put("path", "/paths/" + path);
					String log = elm.attributeValue("log");
					logic.put("log", log);
					map.put(alias, logic);
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			putMap(name, reader, null);
			for (Iterator children = elm.elementIterator("module"); children
					.hasNext();) {
				Element childElm = (Element) children.next();
				String childname = childElm.attribute("name").getValue();
				putMap(childname, reader, name);
			}
		}
	}

	private static void putMap(String name, SAXReader reader, String parent)
			throws Exception {

		InputStream modulePath = PathMapper.class.getClassLoader()
				.getResourceAsStream(
						parent == null ? name + "/path.xml" : parent + "/"
								+ name + "/path.xml");
		Document docPath = reader.read(modulePath);
		Element rootPath = docPath.getRootElement();
		for (Iterator item = rootPath.elementIterator("path"); item.hasNext();) {
			Element elmment = (Element) item.next();
			String aliasPath = elmment.attribute("alias").getValue();
			String pathPath = elmment.attribute("path").getValue();
			String log = elmment.attributeValue("log");

			// 验证别名是否重复
			if (map.containsKey(aliasPath)) {
				throw new Exception("别名" + aliasPath + "已存在");
			}
			String path = (parent == null ? name + "/paths/" : parent
					+ "/" + name + "/paths/")
					+ pathPath;
			// 设置Path属性
			Map<String, String> logic = new HashMap<String, String>();
			logic.put("alias", aliasPath);
			logic.put("path", path);
			logic.put("log", log);
			map.put(aliasPath, logic);
		}
	}

	public void main(String[] args) {
		PathMapper.loadMap();
		for (String key : map.keySet())
			System.out.println(key);
	}
}
