package com.aote.path;

import java.util.HashMap;

import org.hibernate.Session;
import org.json.JSONArray;

import com.af.path.Delegate;
import com.af.path.Program;

public class PathHelper {
	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql) throws Exception {
		Program prog = new Program(sql);
		Delegate d = prog.parse();
		d.session = session;
		JSONArray result = (JSONArray)d.invoke(new HashMap<String, Object>(), session.getSessionFactory());
		return result;
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql, int pageNo,
			int pageSize) throws Exception {
		Program prog = new Program(sql);
		Delegate d = prog.parse();
		d.session = session;
		// 设置sql执行器为分页执行器
		d.sqlRunner = new PagedSqlRunner(pageNo, pageSize);
		JSONArray result = (JSONArray)d.invoke(new HashMap<String, Object>(), session.getSessionFactory());
		return result;
	}	
}
