package com.aote.logic;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.aote.entity.EntityServer;
import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;

@Component
public class LogicServer {
	static Logger log = Logger.getLogger(LogicServer.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private SqlServer sqlServer;

	@Autowired
	private PathServer pathServer;

	@Autowired
	public SessionFactory sessionFactory;
	
	// 安卓模拟时需要的上下文
	private JSONObject context = null;

	// 执行业务逻辑处理过程
	public Object run(String name, String str) throws Exception {
		JSONObject param = null;
		// 把传递过来的参数，放到data里，以便跟entity，sql等对象区别开来
		// 判断传来的数据是否是XML格式
		str = str.trim();
		if (str.startsWith("<") && str.endsWith(">")) {
			// 传来数据为XML格式
			param = new JSONObject();
			param.put("xml", str);
		} else {
			// 传来数据为JSON格式
			Object json = new JSONTokener(str).nextValue();
			if (json instanceof JSONObject) {
				param = new JSONObject(str);
				// 有context部分，取context部分
				if (!param.isNull("context")) {
					context = param.getJSONObject("context");
				}
				if (!param.isNull("data")) {
					param = param.getJSONObject("data");
				}
			} else if (json instanceof JSONArray) {
				param = new JSONObject();
				param.put("arr", new JSONArray(str));
			}
		}
		
		return run(name, param, context);
	}

	// 业务逻辑带一个上下问对象，用于平板端测试
	public Object run(String name, JSONObject param, JSONObject context) throws Exception {
		// 获取源程序内容
		String path = LogicMapper.getLogic(name);
		if (path == null) {
			return new RuntimeException("业务逻辑未找到: " + name);
		}
		
		String source = ResourceHelper.getString(path);
		// 处理回车换行
		source = source.replace("\r\n", "\n");
		// 执行源程序
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("data", param);
		// context用于测试平板端业务逻辑
		if (context != null) {
			params.put("context", context);
		}
		// 附加entityServer, sqlServer等对象到参数中
		params.put("log", this);
		params.put("entity", entityServer);
		params.put("sql", sqlServer);
		params.put("path", pathServer);
		// 把LogicServer自身注册进去
		params.put("logic", this);

		// 附加用户注册的对象到业务逻辑中
		Map<String, Object> plugins = PluginMapper.getPlugins();
		for (String key : plugins.keySet()) {
			params.put(key, plugins.get(key));
		}
		Object result = ExpressionHelper.run(source, params);
		return result;
	}
	
	// 业务逻辑内部调用其它业务逻辑
	public Object run(String name, JSONObject param) throws Exception {
		return run(name, param, this.context);
	}

	// 执行业务逻辑处理过程
	public Object noTranscRun(String name, String str) throws Exception {
		JSONObject param = null;
		// 把传递过来的参数，放到data里，以便跟entity，sql等对象区别开来
		// 判断传来的数据是否是XML格式
		str = str.trim();
		if (str.startsWith("<") && str.endsWith(">")) {
			// 传来数据为XML格式
			param = new JSONObject();
			param.put("xml", str);
		} else {
			// 传来数据为JSON格式
			Object json = new JSONTokener(str).nextValue();
			if (json instanceof JSONObject) {
				param = new JSONObject(str);
				if (!param.isNull("data")) {
					param = param.getJSONObject("data");
				}
			} else if (json instanceof JSONArray) {
				param = new JSONObject();
				param.put("arr", new JSONArray(str));
			}
		}
		return noTranscRun(name, param);
	}

	// 业务逻辑内部调用其它业务逻辑
	public Object noTranscRun(String name, JSONObject param) throws Exception {
		// 获取源程序内容
		String path = LogicMapper.getLogic(name);
		String source = ResourceHelper.getString("/logics/" + path);
		// 处理回车换行
		source = source.replace("\r\n", "\n");
		// 执行源程序
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("data", param);
		// 附加entityServer, sqlServer等对象到参数中
		params.put("log", log);
		params.put("entity", entityServer);
		SqlServer sqlServer = new SqlServer();
		Session session = null;
		try {		
			session = sessionFactory.openSession();
			sqlServer.setAssignedSession(session);
			params.put("sql", sqlServer);
			params.put("session", session);
			// 把LogicServer自身注册进去
			params.put("logic", this);
	
			// 附加用户注册的对象到业务逻辑中
			Map<String, Object> plugins = PluginMapper.getPlugins();
			for (String key : plugins.keySet()) {
				params.put(key, plugins.get(key));
			}
			Object result = new Object();

			result = ExpressionHelper.run(source, params);
			return result;
		} catch (Exception e) {
			if(session != null)
				session.getTransaction().rollback();
			throw e;
		}
		finally {
			if(session != null)
				session.close();
		}

	}
	
	public void debug(Object msg) {
		log.debug(msg); 
	}
	
	/**
	 * 将来可以根据业务逻辑名称配置
	 */
	public void debug(String logic, Object msg) {
		// 获取业务逻辑配置信息
		String level = LogicMapper.getAttr(logic, "log");
		if (level != null) {
			log.debug(logic + ":" + msg);
		}
	}
}
