/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sensitive;

import com.aote.sensitive.SensitiveDataEnhancer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class SensitiveFieldConfigLoader {
    static Logger log = Logger.getLogger(SensitiveFieldConfigLoader.class);
    private static final ConcurrentHashMap<String, String> SENSITIVE_MASK_MAP = new ConcurrentHashMap();

    public static Map<String, String> getSensitiveMaskMap() {
        return SENSITIVE_MASK_MAP;
    }

    public static HashMap<String, SensitiveFieldConfig> loadSensitiveFieldConfigs(Configuration configuration, String entityName) {
        HashMap<String, SensitiveFieldConfig> configs = new HashMap<String, SensitiveFieldConfig>();
        try {
            PersistentClass pc = configuration.getClassMapping(entityName);
            if (pc == null) {
                log.debug((Object)("\u672a\u627e\u5230\u5b9e\u4f53\u6620\u5c04: " + entityName));
                return configs;
            }
            Iterator props = pc.getPropertyIterator();
            while (props.hasNext()) {
                Map<String, String> meta;
                Property prop = (Property)props.next();
                if (prop == null || prop.getMetaAttributes() == null || !prop.getMetaAttributes().containsKey("sensitive") || !"true".equalsIgnoreCase((meta = SensitiveFieldConfigLoader.extractMetaAttributes(prop)).get("sensitive"))) continue;
                String fieldName = prop.getName();
                String strategy = meta.get("mask-strategy");
                if (strategy == null || strategy.trim().isEmpty()) {
                    strategy = SensitiveDataEnhancer.inferStrategy(fieldName);
                }
                SensitiveFieldConfig cfg = new SensitiveFieldConfig();
                cfg.setFieldName(fieldName);
                cfg.setMaskStrategy(strategy);
                configs.put(fieldName, cfg);
                SensitiveFieldConfigLoader.addToGlobalMaskMap(fieldName, strategy, prop);
            }
            if (!configs.isEmpty()) {
                log.info((Object)("\u654f\u611f\u5b57\u6bb5\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210: \u5b9e\u4f53=" + entityName + ", \u6570\u91cf=" + configs.size()));
            }
        }
        catch (Exception e) {
            log.error((Object)("\u52a0\u8f7d\u654f\u611f\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25: " + entityName), (Throwable)e);
        }
        return configs;
    }

    private static Map<String, String> extractMetaAttributes(Property prop) {
        HashMap<String, String> metaAttributes = new HashMap<String, String>();
        try {
            Iterator iterator = prop.getMetaAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = (String)entry.getKey();
                MetaAttribute metaAttr = (MetaAttribute)entry.getValue();
                if (metaAttr.getValues() == null || metaAttr.getValues().isEmpty()) continue;
                String value = metaAttr.getValues().get(0).toString();
                metaAttributes.put(key, value);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u63d0\u53d6meta\u5c5e\u6027\u5931\u8d25: " + prop.getName()), (Throwable)e);
        }
        return metaAttributes;
    }

    private static void addToGlobalMaskMap(String fieldName, String strategy, Property prop) {
        SENSITIVE_MASK_MAP.put(fieldName.toLowerCase(), strategy);
        try {
            String colName;
            Object sel;
            Iterator colIt = prop.getColumnIterator();
            if (colIt != null && colIt.hasNext() && (sel = colIt.next()) instanceof Column && (colName = ((Column)sel).getName()) != null) {
                SENSITIVE_MASK_MAP.put(colName.toLowerCase(), strategy);
            }
        }
        catch (Exception e) {
            log.debug((Object)("\u6dfb\u52a0\u5217\u540d\u5230\u5168\u5c40\u63a9\u7801\u6620\u5c04\u5931\u8d25: " + fieldName), (Throwable)e);
        }
    }

    public static class SensitiveFieldConfig {
        private String fieldName;
        private String maskStrategy;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getMaskStrategy() {
            return this.maskStrategy;
        }

        public void setMaskStrategy(String maskStrategy) {
            this.maskStrategy = maskStrategy;
        }

        public String getMaskStrategyOrDefault() {
            return this.maskStrategy != null ? this.maskStrategy : "default";
        }
    }
}

