/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.aote.ThreadResource;
import com.aote.config.Config;
import com.aote.config.SystemConfig;
import com.aote.util.GetUserIp;
import com.aote.util.JwtUtilNew;
import com.aote.util.other.RestTools;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginFilter
implements Filter {
    static final Logger log = Logger.getLogger(LoginFilter.class);

    static boolean isOk(HttpServletRequest req, String url, Logger log) {
        boolean isOk = false;
        if (Config.isPassUri(url)) {
            isOk = true;
            log.debug((Object)"\u8fdb\u5165\u6307\u5b9aurl\u653e\u884c\u4e86");
        } else if (req.getHeader("appToken") != null) {
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                log.debug((Object)"\u8fdb\u5165appToken\u653e\u884c\u4e86");
                isOk = true;
            }
        } else if (req.getHeader("Authorization") != null) {
            String Token = req.getHeader("Authorization");
            log.debug((Object)("\u83b7\u53d6\u7684Authorization:" + Token));
            if (Token != null && JwtUtilNew.tokenVerify(Token = Token.substring(7))) {
                isOk = true;
            }
        }
        return isOk;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block8: {
            Long startTime = System.currentTimeMillis();
            try {
                String loginId;
                ThreadResource.LoginUser.set(null);
                ThreadResource.ComponentDir.set(null);
                ThreadResource.Token.set(null);
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                String ip = GetUserIp.getIpAdrress(req);
                String url = ip + req.getRequestURI();
                log.debug((Object)("\u4f20\u5165\u7684URL:" + url));
                boolean isOk = LoginFilter.isOk(req, url, log);
                if (!isOk) {
                    log.debug((Object)("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25URL:" + url));
                    resp.setCharacterEncoding("UTF-8");
                    resp.setStatus(403);
                    resp.getWriter().write("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff01");
                    return;
                }
                String sessionId = req.getHeader("session");
                ThreadResource.SessionId.set(sessionId == null ? null : Integer.valueOf(sessionId));
                String componentDir = req.getHeader("componentDir");
                log.debug((Object)("\u83b7\u53d6\u7684componentDir" + componentDir));
                if (componentDir != null) {
                    ThreadResource.ComponentDir.set(componentDir);
                }
                if ((loginId = req.getHeader("Token")) == null) break block8;
                ThreadResource.Token.set(loginId);
                log.debug((Object)("loginId=" + loginId));
                if (SystemConfig.System.hasLdapUrl()) {
                    log.error((Object)"systemConfig.json\u65e0ldap\u914d\u7f6e");
                    return;
                }
                String ldap = SystemConfig.System.getLdapUrl();
                try {
                    String str = RestTools.post(ldap + "/rs/search", "{source:'this.getInfo()',userid:'" + loginId + "'}");
                    log.debug((Object)("\u7528\u6237\u4fe1\u606f\uff1a" + str));
                    JSONObject json = new JSONObject(str);
                    String PermissionObjStr = RestTools.post(ldap + "/rs/search", "{source:'this.getRights().where(row.getType()==$function$ && row.getPath($name$).indexOf($\u529f\u80fd\u6743\u9650$) != -1)',userid:'" + loginId + "'}");
                    JSONArray PermissionObjArr = new JSONArray(PermissionObjStr);
                    JSONArray PermissionArr = new JSONArray();
                    for (int i = 0; i < PermissionObjArr.length(); ++i) {
                        if (PermissionObjArr.getJSONObject(i).optString("name").isEmpty()) continue;
                        PermissionArr.put((Object)PermissionObjArr.getJSONObject(i).optString("name"));
                    }
                    json.put("permissions", (Object)PermissionArr);
                    ThreadResource.LoginUser.set(json);
                }
                catch (Exception e) {
                    log.error((Object)"\u62e6\u622a\u5668 \u83b7\u53d6\u6743\u9650\u5931\u8d25 \u6743\u9650\u5224\u65ad\u53ef\u80fd\u6709\u8bef \u4e0d\u5f71\u54cd\u4e3b\u8981\u4e1a\u52a1\uff1a", (Throwable)e);
                }
                log.debug((Object)("\u8fdb\u5165chain.doFilter:" + url));
                chain.doFilter(request, response);
                log.debug((Object)("\u7ed3\u675fchain.doFilter:" + url));
                Long endTime = System.currentTimeMillis();
                log.debug((Object)(url + ",\u62e6\u622a\u5668\u8017\u65f6:" + (endTime - startTime)));
            }
            catch (Exception e) {
                log.error((Object)"\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
        }
    }

    public void destroy() {
    }
}

