/*
 * Decompiled with CFR 0.152.
 */
package com.aote.config;

import com.aote.exception.FileNotFoundException;
import com.aote.util.other.JsonTools;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SystemConfig {
    private static final Logger LOGGER = Logger.getLogger(SystemConfig.class);
    public static final String CONFIG_PATH = "systemConfig.json";
    public static final String OLD_CONFIG_PATH = "config.json";
    private static volatile boolean isLoaded = false;

    private static void load() {
        if (!isLoaded) {
            JSONObject redis;
            isLoaded = true;
            JSONObject params = new JSONObject();
            if (SystemConfig.class.getClassLoader().getResource(OLD_CONFIG_PATH) != null) {
                JSONObject oldParams = JsonTools.readJsonFile(OLD_CONFIG_PATH);
                JSONObject system = new JSONObject();
                if (oldParams.has("proxy")) {
                    system.put("proxyUrl", (Object)oldParams.getString("proxy"));
                }
                if (oldParams.has("ldap")) {
                    system.put("ldapUrl", (Object)oldParams.getString("ldap"));
                }
                params.put("system", (Object)system);
                redis = new JSONObject();
                if (oldParams.has("logicRegister")) {
                    JSONObject logicRegister = oldParams.getJSONObject("logicRegister");
                    redis.put("registerUrl", (Object)logicRegister.getString("url"));
                    JSONObject redisObj = logicRegister.getJSONObject("redis");
                    redis.put("hostName", (Object)(redisObj.getString("host") + ":" + redisObj.getString("port")));
                    if (redisObj.has("redispwd")) {
                        redis.put("password", (Object)redisObj.getString("redispwd"));
                    }
                }
                params.put("redis", (Object)redis);
                params.put("persistenceLog", (Object)new JSONObject());
                params.put("resources", (Object)new JSONObject());
            }
            if (SystemConfig.class.getClassLoader().getResource(CONFIG_PATH) != null) {
                params = JsonTools.addJSON(params, JsonTools.readJsonFile(CONFIG_PATH));
            }
            if (params.isEmpty()) {
                throw new FileNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6systemConfig.json\u4e0d\u5b58\u5728", CONFIG_PATH);
            }
            JSONObject system = params.getJSONObject("system");
            System.webAppName = system.optString("webAppName");
            if (system.has("proxyUrl")) {
                System.proxyUrl = system.getString("proxyUrl");
            }
            if (system.has("ldapUrl")) {
                System.ldapUrl = system.getString("ldapUrl");
            }
            if (system.has("check")) {
                System.check = system.getString("check");
            }
            JSONObject persistenceLog = params.optJSONObject("persistenceLog");
            PersistenceLog.isEnabled = persistenceLog.optBoolean("isEnabled", false);
            if (PersistenceLog.isEnabled.booleanValue()) {
                LOGGER.info((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5f00\u542f\uff0c\u5982\u9700\u5173\u95ed\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3afalse.");
            } else {
                LOGGER.warn((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5173\u95ed\uff0c\u5982\u9700\u5f00\u542f\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3atrue.");
            }
            redis = params.getJSONObject("redis");
            if (!redis.has("hostName")) {
                LOGGER.warn((Object)"Redis\u672a\u914d\u7f6e\uff0c\u90e8\u5206\u529f\u80fd\u5c06\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
            } else {
                Redis.hostName = redis.getString("hostName");
                if (!redis.has("registerUrl")) {
                    LOGGER.warn((Object)"\u4e1a\u52a1redis\u6ce8\u518c\u5730\u5740\u672a\u914d\u7f6e\uff0c\u90e8\u5206\u529f\u80fd\u5c06\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                } else {
                    Redis.registerUrl = redis.getString("registerUrl");
                }
                if (redis.has("password")) {
                    Redis.password = redis.getString("password");
                }
                if (redis.has("codecType")) {
                    Redis.codecType = redis.optString("codecType", "String");
                }
            }
            JSONObject resources = params.getJSONObject("resources");
            if (!resources.has("fileRootPath")) {
                LOGGER.warn((Object)("systemConfig.json\u4e2d\u8d44\u6e90\u6839\u76ee\u5f55\u53c2\u6570[resources:fileRootPath]\u4e0d\u5b58\u5728\uff0c\u4ee5\u6309\u7167\u7f3a\u7701\u503c[D:/" + System.webAppName + "Res]\u914d\u7f6e"));
            }
            Resources.fileRootPath = resources.optString("fileRootPath", "D:/" + System.webAppName + "Res");
            if (resources.has("extraPaths")) {
                Resources.extraPaths = resources.getJSONObject("extraPaths");
            }
            SubClass.subClassArray = params.optJSONArray("subclass");
            JSONObject dataSecurity = params.optJSONObject("dataSecurity");
            if (Optional.ofNullable(dataSecurity).isPresent()) {
                DataSecurity.enableDataEncryption = dataSecurity.optBoolean("enableDataEncryption", false);
                DataSecurity.maskSensitiveData = dataSecurity.optBoolean("maskSensitiveData", false);
                DataSecurity.aesKey = dataSecurity.optString("aesKey");
                DataSecurity.injectionCheck = dataSecurity.optBoolean("injectionCheck", false);
                DataSecurity.passUrl = dataSecurity.optString("passUrl");
            } else {
                DataSecurity.enableDataEncryption = false;
                DataSecurity.injectionCheck = false;
            }
        }
    }

    public static class DataSecurity {
        private static Boolean enableDataEncryption;
        private static Boolean maskSensitiveData;
        private static String aesKey;
        private static Boolean injectionCheck;
        private static String passUrl;

        public static boolean getEnableDataEncryption() {
            return enableDataEncryption;
        }

        public static boolean getMaskSensitiveData() {
            return maskSensitiveData;
        }

        public static String getAesKey() {
            return aesKey;
        }

        public static boolean hasAesKey() {
            return aesKey != null;
        }

        public static boolean getInjectionCheck() {
            return injectionCheck;
        }

        public static String getPassUrl() {
            return passUrl;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class SubClass {
        private static JSONArray subClassArray;

        public static JSONArray getSubClassArray() {
            return subClassArray;
        }

        public static boolean hasSubClassArray() {
            return subClassArray != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Resources {
        private static String fileRootPath;
        private static JSONObject extraPaths;

        public static String getFileRootPath() {
            return fileRootPath;
        }

        public static String getExtraPath(String key) {
            return extraPaths.getString(key);
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Redis {
        private static String hostName;
        private static String password;
        private static String registerUrl;
        private static String codecType;

        public static String getHostName() {
            return hostName;
        }

        public static boolean hasHostName() {
            return hostName != null;
        }

        public static String getPassword() {
            return password;
        }

        public static boolean hasPassword() {
            return password != null;
        }

        public static String getRegisterUrl() {
            return registerUrl;
        }

        public static boolean hasRegisterUrl() {
            return registerUrl != null;
        }

        public static String getCodecType() {
            return codecType;
        }

        public static boolean hasCodecType() {
            return codecType != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class PersistenceLog {
        private static Boolean isEnabled;

        public static Boolean getEnabled() {
            return isEnabled;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class System {
        private static String webAppName;
        private static String proxyUrl;
        private static String ldapUrl;
        private static String check;

        public static String getWebAppName() {
            return webAppName;
        }

        public static String getProxyUrl() {
            return proxyUrl;
        }

        public static boolean hasProxyUrl() {
            return proxyUrl != null;
        }

        public static String getCheck() {
            return check;
        }

        public static boolean hasCheck() {
            return check != null;
        }

        public static String getLdapUrl() {
            return ldapUrl;
        }

        public static boolean hasLdapUrl() {
            return ldapUrl == null;
        }

        static {
            SystemConfig.load();
        }
    }
}

