package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;

import java.io.*;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;

@Path("resource")
@Component
@Transactional
public class FileService {

    static Logger log = Logger.getLogger(FileService.class);

    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;

    private static byte[] subBytes(byte[] b, int from, int end) {
        byte[] result = new byte[end - from];
        System.arraycopy(b, from, result, 0, end - from);
        return result;
    }

    private static int locateEnd(byte[] bytes, int start, int end, String endStr) {
        byte[] endByte = endStr.getBytes();
        for (int i = start + 1; i < end; i++) {
            if (bytes[i] == endByte[0]) {
                int k = 1;
                while (k < endByte.length) {
                    if (bytes[i + k] != endByte[k]) {
                        break;
                    }
                    k++;
                }

                if (i == 3440488) {
                    System.out.println("start");
                }
                // 返回结束符的开始位置
                if (k == endByte.length) {
                    return i;
                }
            }
        }
        return 0;
    }

    @POST
    @Path("upload")
    public String fileUpload(@Context HttpServletRequest request,
                             @Context HttpServletResponse response) throws Exception {
        String realpath = getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(realpath + File.separator + getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }
        String downloadpath;
        String username = URLDecoder.decode(request.getHeader("username"), "UTF-8");
        String blodid = request.getHeader("blodid");
        String f_usetype = null;
        String f_remarks = null;
        if (request.getHeader("f_usetype") != null) {
            f_usetype = URLDecoder.decode(request.getHeader("f_usetype"), "UTF-8");
        }
        if (request.getHeader("f_remarks") != null) {
            f_remarks = URLDecoder.decode(request.getHeader("f_remarks"), "UTF-8");
        }

        downloadpath = getPath("downloadpath");

        System.out.println(downloadpath);
        System.out.println(username);
        System.out.println(blodid);
        System.out.println(realpath);
        // 1.判断当前request消息实体的总长度
        int totalBytes = request.getContentLength();
        System.out.println("当前数据总长度:" + totalBytes);
        // 2.在消息头类型中找出分解符,例如:boundary=----WebKitFormBoundaryeEYAk4vG4tRKAlB6
        String contentType = request.getContentType();
        System.out.println(contentType);
        int position = contentType.indexOf("boundary=");

        String startBoundary = "--"
                + contentType.substring(position + "boundary=".length());
        String endBoundary = startBoundary + "--";
        // 将request的输入流读入到bytes中
        InputStream inputStream = request.getInputStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] bytes = new byte[totalBytes];
        dataInputStream.readFully(bytes);
        dataInputStream.close();
        BufferedReader reader = new BufferedReader(new StringReader(new String(
                bytes)));
        int temPosition = 0;
        boolean flag = false;
        int end = 0;
        while (true) {
            // 当读取一次文件信息后
            if (flag) {
                bytes = subBytes(bytes, end, totalBytes);
                temPosition = 0;
                reader = new BufferedReader(new StringReader(new String(bytes)));
            }
            // 读取一行的信息:------WebKitFormBoundary5R7esAd459uwQsd5,即:lastBoundary
            String str = reader.readLine();
            System.out.println("this line is:" + str);
            // 换行算两个字符
            temPosition += str.getBytes().length + 2;
            // endBoundary:结束
            if (str.equals(endBoundary)) {
                break;
            }
            // 表示头信息的开始(一个标签,input,select等)
            if (str.startsWith(startBoundary)) {
                // 判断当前头对应的表单域类型

                str = reader.readLine(); // 读取当前头信息的下一行:Content-Disposition行
                temPosition += str.getBytes().length + 2;

                int position1 = str.indexOf("filename="); // 判断是否是文件上传
                // such as:Content-Disposition: form-data; name="fileName";
                // filename="P50611-162907.jpg"
                if (position1 == -1) {// 表示是普通文本域上传

                } else {// position1!=-1,表示是文件上传
                    // 解析当前上传的文件对应的name(input标签的name),以及fieldname:文件名
                    int position2 = str.indexOf("name=");
                    // 去掉name与filename之间的"和;以及空格
                    String name = str.substring(position2 + "name=".length()
                            + 1, position1 - 3);
                    // 去掉两个"

                    String filename = str.substring(
                            position1 + "filename=".length() + +1,
                            str.length() - 1);
                    filename = new String(filename.getBytes(), StandardCharsets.UTF_8);

                    String uploaddate = getDate();
                    filename = filename.substring(0, filename.lastIndexOf('.')) + "_" + username + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf('.') + 1);

                    System.out.println(filename);
                    // 读取行,such as:Content-Type: image/jpeg,记录字节数,此处两次换行
                    temPosition += (reader.readLine().getBytes().length + 4);
                    end = locateEnd(bytes, temPosition, totalBytes,
                            endBoundary);
                    DataOutputStream dOutputStream = new DataOutputStream(
                            new FileOutputStream(new File(
                                    file.getAbsolutePath() + File.separator
                                            + filename)));
                    dOutputStream.write(bytes, temPosition, end - temPosition
                            - 2);
                    dOutputStream.close();
                    flag = true;
                    downloadpath = file.getAbsolutePath() + File.separator + filename;
                    // String filetype=filename.split("\\.")[1];
                    String filetype = filename.substring(filename.lastIndexOf('.') + 1);
                    Map<String, Object> map = new HashMap<>();
                    map.put("f_filename", filename);
                    map.put("f_username", username);
//                    map.put("f_uploaddate", uploaddate);
                    map.put("f_blobid", blodid);
                    map.put("f_filetype", filetype);
                    map.put("f_downloadpath", downloadpath);
                    map.put("f_realpath", realpath);
                    map.put("f_usetype", f_usetype);
                    map.put("f_remarks", f_remarks);
                    String jsonFileID = entityServer.save("t_files", map);
                    JSONObject JObj = new JSONObject(jsonFileID);
                    int id = (int) JObj.get("id");
                    map.put("id", id);
                    result = new JSONObject(map);
                }
            }
        }
        result.put("path", downloadpath);
        result.put("result", "success");
        System.out.println("1111111111" + result.toString());
        return result.toString();
    }

    @POST
    @Path("uploadFile")
    public String fileUpload2(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String savePath = getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(savePath + File.separator + getNowDate());
        //判断上传文件的保存目录是否存在
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        String downloadpath;
        //获取所有请求头参数
        Enumeration headerNames = request.getHeaderNames();
        Map<String, Object> map = new HashMap<>();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent(request)) {
            return "";
        }
        List<FileItem> list = upload.parseRequest(request);
        for (FileItem item : list) {
            if (!item.isFormField()) {
                //获得文件名
                String filename = item.getName();
                System.out.println("filename===" + filename);
                String uploaddate = getDate();
                filename = filename.substring(0, filename.lastIndexOf('.')) + "_" + map.get("username") + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf('.') + 1);
                System.out.println(filename);
                //获取item中的上传文件的输入流
                InputStream in = item.getInputStream();
                // 自定义文件名

                //创建一个文件输出流
                FileOutputStream out = new FileOutputStream(file.getAbsolutePath() + File.separator + filename);
                //创建一个缓冲区
                byte[] buffer = new byte[1024];
                //判断输入流中的数据是否已经读完的标识
                int len = 0;
                //循环将输入流读入到缓冲区当中，(len=in.read(buffer))>0就表示in里面还有数据
                while ((len = in.read(buffer)) > 0) {
                    //使用FileOutputStream输出流将缓冲区的数据写入到指定的目录(savePath + "\\" + filename)当中
                    out.write(buffer, 0, len);
                }
                //关闭输入流
                in.close();
                //关闭输出流
                out.close();
                //删除处理文件上传时生成的临时文件
                item.delete();
                // 给数据库里保存
                downloadpath = file.getAbsolutePath() + File.separator + filename;
                String filetype = filename.substring(filename.lastIndexOf('.') + 1);
                if (map.get("blodid") != null && !"".equals(((String) map.get("blodid")).trim())) {
                    //存f_userinfo_id
                    map.put("f_blobid", map.get("blodid"));
                }
                if(map.containsKey("businessid")){
                    //存业务id
                    if (map.get("businessid") != null && !"".equals(((String) map.get("businessid")).trim())) {
                        map.put("f_businessid", map.get("businessid"));
                    }
                }
                if (map.get("username") != null && !"".equals(((String) map.get("username")).trim())) {
                    map.put("f_username", map.get("username"));
                }
                map.put("f_filename", filename);
//				String uploadFileDate = getFileUploadDate();
//				map.put("f_uploaddate", uploadFileDate);
                map.put("f_filetype", filetype);
                map.put("f_downloadpath", downloadpath);
                map.put("f_realpath", savePath);
                String jsonFileID = entityServer.partialSave("t_files", new JSONObject(map));
                JSONObject JObj = new JSONObject(jsonFileID);
                map.put("id", JObj.get("id"));
                result = new JSONObject(map);
            }
        }
        result.put("result", "success");
        return result.toString();
    }

    @POST
    @Path("uploadFileNoLimitFileType")
    public String fileUploadNoLimitFileType(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String savePath = getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(savePath + File.separator + getNowDate());
        //判断上传文件的保存目录是否存在
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        String downloadpath;
        //获取所有请求头参数
        Enumeration headerNames = request.getHeaderNames();
        Map<String, Object> map = new HashMap<>();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent(request)) {
            return "";
        }
        List<FileItem> list = upload.parseRequest(request);
        for (FileItem item : list) {
            if (!item.isFormField()) {
                //获得文件名
                String filename = item.getName();
                System.out.println("filename===" + filename);
                if (filename == null || "".equals(filename.trim())) {
                        continue;
                }
                String uploaddate = getDate();
                filename = filename.substring(0, filename.lastIndexOf('.')) + "_" + map.get("username") + "_" + uploaddate + "." + filename.substring(filename.lastIndexOf('.') + 1);
                System.out.println(filename);
                //获取item中的上传文件的输入流
                InputStream in = item.getInputStream();
                // 自定义文件名

                //创建一个文件输出流
                FileOutputStream out = new FileOutputStream(file.getAbsolutePath() + File.separator + filename);
                //创建一个缓冲区
                byte[] buffer = new byte[1024];
                //判断输入流中的数据是否已经读完的标识
                int len = 0;
                //循环将输入流读入到缓冲区当中，(len=in.read(buffer))>0就表示in里面还有数据
                while ((len = in.read(buffer)) > 0) {
                    //使用FileOutputStream输出流将缓冲区的数据写入到指定的目录(savePath + "\\" + filename)当中
                    out.write(buffer, 0, len);
                }
                //关闭输入流
                in.close();
                //关闭输出流
                out.close();
                //删除处理文件上传时生成的临时文件
                item.delete();
                // 给数据库里保存
                downloadpath = file.getAbsolutePath() + File.separator + filename;
                String filetype = filename.substring(filename.lastIndexOf('.') + 1);
                if (map.get("blodid") != null && !"".equals(((String) map.get("blodid")).trim())) {
                    map.put("f_blobid", map.get("blodid"));
                }
                if (map.get("username") != null && !"".equals(((String) map.get("username")).trim())) {
                    map.put("f_username", map.get("username"));
                }
                map.put("f_filename", filename);
//				String uploadFileDate = getFileUploadDate();
//				map.put("f_uploaddate", uploadFileDate);
                map.put("f_filetype", filetype);
                map.put("f_downloadpath", downloadpath);
                map.put("f_realpath", savePath);
                String jsonFileID = entityServer.partialSave("t_files", new JSONObject(map));
                JSONObject JObj = new JSONObject(jsonFileID);
                map.put("id", JObj.get("id"));
                result = new JSONObject(map);
            }
        }
        result.put("result", "success");
        return result.toString();
    }

    @POST
    @Path("uploadFileNew")
    public String fileUploadNew(@Context HttpServletRequest request,
                                @Context HttpServletResponse response,
                                @QueryParam("FileName") String filename,
                                @QueryParam("BlobId") String blob_id,
                                @QueryParam("EntityName") String EntityName) throws Exception {
        //获取文件保存路径
        String savePath = getPath("uploadFilepath");
        //如果不存在则新建文件夹
        File file = new File(savePath + File.separator + getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }

        //获取所有请求头参数
        Enumeration headerNames = request.getHeaderNames();
        Map<String, Object> map = new HashMap<>();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), "UTF-8");
            map.put(key, value);
        }

        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setHeaderEncoding("UTF-8");
        if (!ServletFileUpload.isMultipartContent(request)) {
            return "";
        }
        List<FileItem> list = upload.parseRequest(request);

        String realFileName = null;

        String result = null;
        // 循环遍历，取出单个文件
        for (FileItem item : list) {
            if (!item.isFormField()) {
                CommonsMultipartFile mf = new CommonsMultipartFile(item);
                // 获得原始文件名
                realFileName = mf.getOriginalFilename();
                String name1 = mf.getName();
                // 截取文件名
                String fileName = realFileName.substring(0, realFileName.lastIndexOf('.'));
                // 截取文件类型; 这里可以根据文件类型进行判断
                String fileType = realFileName.substring(realFileName.lastIndexOf('.'));
                // 上传时间
                String uploadDate = getDate();
                // 如果请求头中有用户名字段
                if (map.containsKey("username")) {
                    realFileName = fileName + "_" + map.get("username") + "_" + uploadDate + fileType;
                } else {
                    realFileName = fileName + "_" + uploadDate + fileType;
                }

                // 文件结果处理
                // 为了兼容文件存在数据库还是磁盘中 做判断
                if (EntityName != null && EntityName.equals("t_blob")) {  // 放在数据库t_blob表中
                    try {
                        map.put("filename", filename);
                        map.put("id", blob_id);
                        Session session = sessionFactory.getCurrentSession();
                        map.put("blob", Hibernate.getLobCreator(session).createBlob(mf.getBytes()));
                        session.saveOrUpdate(EntityName, map);
                        session.flush();
                        result = "";
                    } catch (Exception e) {
                        throw new WebApplicationException(500);
                    }
                } else { // 放在磁盘中
                    //结果集
                    JSONObject params = new JSONObject();
                    String downloadpath = file.getAbsolutePath() + File.separator + filename;
                    try {
                        // 将文件存储
                        mf.transferTo(new File(downloadpath));
                        if (map.get("blodid") != null && !"".equals(((String) map.get("blodid")).trim())) {
                            map.put("f_blobid", map.get("blodid"));
                        }
                        if (map.get("username") != null && !"".equals(((String) map.get("username")).trim())) {
                            map.put("f_username", map.get("username"));
                        }
                        map.put("f_filename", filename);
//				String uploadFileDate = getFileUploadDate();
//				map.put("f_uploaddate", uploadFileDate);
                        map.put("f_filetype", fileType);
                        map.put("f_downloadpath", downloadpath);
                        map.put("f_realpath", savePath);
                        String jsonFileID = entityServer.partialSave("t_files", new JSONObject(map));
                        JSONObject JObj = new JSONObject(jsonFileID);
                        map.put("id", JObj.get("id"));
                        params = new JSONObject(map);
                        params.put("result", "success");
                    } catch (IOException e) {
                        e.printStackTrace();
                        params.put("result", "error");
                    }
                    result = params.toString();
                }
            }
        }

        return result;
    }

    /**
     * 通过filepath获取文件
     * @return
     */
    @Path("getUploadFile")
    @POST
    public byte[] getFileOfFilePath(@Context HttpServletRequest request,
                                    @Context HttpServletResponse response, String values) {
        try {
            // 获得文件
            values = values.replaceAll("\\\\", "/");
            JSONObject params = new JSONObject(values);
            Object object = params.get("filepath");
            String filepath = (String) object;
            System.out.println(filepath);
            File file = new File(filepath);
            String filename = filepath.substring(filepath.lastIndexOf("/") + 1);
            FileInputStream in = new FileInputStream(file);
            byte[] result = new byte[(int) file.length()];
            in.read(result);
            in.close();
            return result;
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 保存文件
    @SuppressWarnings("finally")
    @Path("savefile")
    @POST
    public String savefile(byte[] file, @QueryParam("filename") String filename, @QueryParam("module") String module) {
        try {
            String realpath = ModuleMapper.getAttr(module, "upload");
            realpath = this.getRealPath(realpath) + File.separator + filename;
            DataOutputStream dOutputStream =
                    new DataOutputStream(new FileOutputStream(new File(realpath)));
            dOutputStream.write(file);
            dOutputStream.close();
            // 把文件路径存入文件映射表
            String filetype = filename.split("\\.")[1];
            JSONObject map = new JSONObject();
            map.put("f_filename", filename);
            String uploaddate = getFileUploadDate();
            map.put("f_uploaddate", uploaddate);
            map.put("f_filetype", filetype);
            map.put("f_realpath", realpath);
            map.put("f_downloadpath", realpath);
            JSONObject result = new JSONObject(entityServer.partialSave("t_files", map));
            return result.getString("id");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 获得图片
    @Path("getfile/{id}")
    @GET
    public byte[] getfile(@PathParam("id") String id) {
        try {
            // 获取文件真实路径
            JSONArray array = this.sqlServer.query(
                    "select f_downloadpath from t_files where id=" + id
            );
            if (array.length() == 0) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);
            // 获得文件名
            String filename = map.getString("f_downloadpath");
            // 获得文件
            File file = new File(filename);
            FileInputStream in = new FileInputStream(file);
            byte[] result = new byte[(int) file.length()];
            in.read(result);
            //response.setStatus(HttpServletResponse.SC_OK);
            //response.setContentType("application/octet-stream");
            //response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            // 把文件的内容送入响应流中
            //OutputStream os = new BufferedOutputStream(response.getOutputStream());
            //transformStream(in, os);
            //in.close();
            //os.close();
            return result;
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 获得图片
    @Path("getfile2/{id}")
    @GET
    public String getfile2(@PathParam("id") String id) {
        try {
            byte[] files = getfile(id);
            Base64.Encoder encoder = Base64.getEncoder();
            return new String(encoder.encode(files), StandardCharsets.UTF_8);
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            // 读取的实际长度
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    // 按系统日期，建立不同文件夹，获取建立的文件夹位置
    private String getRealPath(String realpath) {
        // 进入模块文件夹
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean validateFileName (String name) {
        if (name == null || "".equals(name)) {
            return false;
        }
        String[] uploadType = {"doc","docx","xls","xlsx","jpg","png","gif","bmp","avi","mp4","wmv","rmvb","mov","pdf"};
        String suffix = getSuffix(name).toLowerCase();
        return Arrays.asList(uploadType).contains(suffix);
    }

    private String getSuffix (String name) {
        return name.split("\\.")[name.split("\\.").length-1];
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public String getDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    /**
     * 获取配置文件上传的真实存储路径
     */

    public String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }

    /**
     * 删除文件
     */
    @POST
    @Path("deleteFile")
    public String deleteFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws JSONException, IOException {
        request.setCharacterEncoding("utf-8");
        JSONObject obj = new JSONObject(new JSONTokener(request.getInputStream()));
        System.out.println(obj.toString());

        String path = new String(obj.getString("path").getBytes(), StandardCharsets.UTF_8);
        String blobid = obj.getString("blobid");
        System.out.println(path);
        path.split("/");
        System.out.println(blobid);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            Session session = sessionFactory.openSession();
            Query query = session.createQuery("delete from t_files where blobid='" + blobid + "' and "
                    + "filename='" + path.split("/")[path.split("/").length - 1] + "'");
            query.executeUpdate();
            session.close();
            System.out.println("success");
            return "success";
        }
        System.out.println("file is not exists");
        return "file is not exists";

    }

    /**
     * 从资源文件的vue目录里获取vue组件文件内容
     *
     * @param fileName 文件名称，支持汉字
     * @return 文件内容
     */
    @GET
    @Path("vue/{filename}")
    public String getVueFile(@PathParam("filename") String fileName) {
        log.debug(fileName);
        String result = null;
        try {
            result = ResourceHelper.getString("/vue/" + fileName);
        } catch (FileNotFoundException e) {
            throw new RuntimeException("/vue/" + fileName + " 文件无配置");
        } catch (IOException io) {
            throw new RuntimeException(io);
        }
        return result;
    }

    private String makeFileName(String filename) {
        //为防止文件覆盖的现象发生，要为上传文件产生一个唯一的文件名
        return UUID.randomUUID().toString() + "_" + filename;
    }

    private String makePath(String filename, String savePath) {
        //得到文件名的hashCode的值，得到的就是filename这个字符串对象在内存中的地址
        int hashcode = filename.hashCode();
        //构造新的保存目录
        String dir = savePath;
        //File既可以代表文件也可以代表目录
        File file = new File(dir);
        //如果目录不存在
        if (!file.exists()) {
            //创建目录
            file.mkdirs();
        }
        return dir;
    }

    @POST
    @Path("fileSave")
    public String saveFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        // 获取保存路径
        String savepath = getPath("uploadFilepath");
        // 在保存路径下创建根据时间分组的文件夹
        File file = new File(savepath + File.separator + getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }
        // 获取保存文件名
        String fileName = request.getHeader("file-name");
        // 输出至对应文件夹下
        File outFile = new File(file.getPath() + "\\" + fileName);
        DataOutputStream dout = null;
        DataInputStream dis = null;
        try {
            // 输出流
            dout = new DataOutputStream(new FileOutputStream(outFile));
            // 输入流
            dis = new DataInputStream(request.getInputStream());
            // 缓冲区
            byte[] buffer = new byte[1024 * 1024];
            int bLength;
            while ((bLength = dis.read(buffer)) > 0) {
                dout.write(buffer, 0, bLength);
            }
            // 传输完成
            dout.flush();
            return "{code:200,msg:'" + fileName + "'}";
        } catch (IOException e) {
            log.error(e);
        } finally {
            if (dout != null) {
                dout.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        return "{code:500,msg:'服务器内部错误'}";
    }
}
