package com.aote.filter;

import com.aote.ThreadResource;
import com.aote.config.Config;
import com.aote.config.SystemConfig;
import com.aote.rs.mapper.WebException;
import com.aote.util.GetUserIp;
import com.aote.util.JwtUtilNew;
import com.aote.util.other.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

public class LoginFilter implements Filter {
    static final Logger log = Logger.getLogger(LoginFilter.class);

    static boolean isOk(HttpServletRequest req, String url, Logger log) {
        boolean isOk = false;
        if (Config.isPassUri(url)) {
            isOk = true;
            log.debug("进入指定url放行了");
        } else if (req.getHeader("appToken") != null) {
            //APP请求判断
            String appToken = req.getHeader("appToken");
            if (Objects.equals(appToken, "db4afb0c04ab4af0b5626998fe7c9b21")) {
                log.debug("进入appToken放行了");
                isOk = true;
            }
        } else if (req.getHeader("Authorization") != null) {
            // 从请求头中获取Token
            String Token = req.getHeader("Authorization");
            log.debug("获取的Authorization:" + Token);
            if (Token != null) {
                Token = Token.substring(7);
                if (JwtUtilNew.tokenVerify(Token)) {
                    isOk = true;
                }
            }
        }
        return isOk;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 开始时间
        Long startTime = System.currentTimeMillis();
        try {
            // 清除线程变量
            ThreadResource.LoginUser.set(null);
            ThreadResource.ComponentDir.set(null);
            ThreadResource.Token.set(null);
            HttpServletRequest req = (HttpServletRequest) request;

            String ip = GetUserIp.getIpAdrress(req);
            String url = ip + req.getRequestURI();
            log.debug("传入的URL:" + url);

            //登录请求判断
            boolean isOk = LoginFilter.isOk(req, url, log);
            if (!isOk) {
                log.debug("用户认证失败URL:" + url);
                throw new WebException(401, "用户认证失败！");
            }
//      ----------到这鉴权成功-----------
            // 从请求头获取sessionid
            String sessionId = req.getHeader("session");
            ThreadResource.SessionId.set(sessionId == null ? null : Integer.valueOf(sessionId));

            // 从请求头获取公司目录配置
            String componentDir = req.getHeader("componentDir");
            log.debug("获取的componentDir" + componentDir);
            // 如果有公司目录配置，不管人，直接把公司目录放到线程变量里
            if (componentDir != null) {
                ThreadResource.ComponentDir.set(componentDir);
            } else {
                // 获取登陆人
                String loginId = req.getHeader("Token");
                if (loginId != null) {
                    // 把token传递下去
                    ThreadResource.Token.set(loginId);
                    log.debug("loginId=" + loginId);
                    // 得到ldap服务地址，将通过ldap服务添加功能
                    if (SystemConfig.System.hasLdapUrl()) {
                        log.error("systemConfig.json无ldap配置");
                        return;
                    }
                    String ldap = SystemConfig.System.getLdapUrl();
                    // 根据用户id从ldap中获取业务逻辑等内容存放路径·
                    log.debug("开始执行rs/search");
                    String str = RestTools.post(ldap + "/rs/search", "{source:'this.getInfo()',userid:'" + loginId + "'}");
                    log.debug("rs/search返回:" + str);
                    JSONObject json = new JSONObject(str);
                    // 把用户完整信息存放到线程变量里
                    ThreadResource.LoginUser.set(json);
                    String res = json.optString("dir", "null");
                    log.debug("组件目录：" + res);
                    if (res != null && !"null".equals(res)) {
                        // 把存放路径放到线程变量中，供其他地方调用
                        ThreadResource.ComponentDir.set(res);
                    }
                }
            }
            log.debug("进入chain.doFilter:" + url);
            chain.doFilter(request, response);
            log.debug("结束chain.doFilter:" + url);
            Long endTime = System.currentTimeMillis();
            log.debug(url + ",拦截器耗时:" + (endTime - startTime));
        } catch (Exception e) {
            log.error("拦截器异常:", e);
            throw e;
        }
    }

    @Override
    public void destroy() {
    }
}
