/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.exception.ExceptionLogManage;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.Util;
import com.aote.util.other.AESUtil;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static final Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    @GET
    @Path(value="/clear")
    public String clearSQLCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        ResourceHelper.clearPathCache();
        return "ok";
    }

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.sqlEncrypt(name, str, 1, new int[0]);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name + "/n", str);
            throw ex;
        }
    }

    public String txgetTotalCnt(String name, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 1, new int[0]);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name + "/n", str);
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.sqlEncrypt(name, str, 2, pageNo, pageSize);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name, str);
            throw ex;
        }
    }

    public String txExecute(String name, int pageNo, int pageSize, String str) throws Exception {
        try {
            return this.sqlEncrypt(name, str, 2, pageNo, pageSize);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/" + name, str);
            throw ex;
        }
    }

    public String txQuery(String sql) throws Exception {
        try {
            return this.sqlEncrypt(sql, "{}", 6, 0, 0);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.sqlEncrypt(name, str, 3, new int[0]);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/n", str);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.sqlEncrypt(name, str, 4, pageNo, pageSize);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name, str);
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/all")
    public String txHqlExecuteAll(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
        try {
            str = Util.aesWhiteList(request, str);
            return this.sqlEncrypt(name, str, 5, pageNo, pageSize);
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 2);
            log.error((Object)stack);
            this.exceptionLogManage.writeError(ex, name, "/rs/sql/hql/" + name + "/all", str);
            throw ex;
        }
    }

    private String sqlEncrypt(String sqlName, String param, int method, int ... value) throws Exception {
        JSONObject paramJson = new JSONObject(param);
        return AESUtil.encryptData(paramJson, "rs/sql/" + sqlName, data -> {
            if (method == 1) {
                return this.sqlServer.queryTotal(sqlName, data).toString();
            }
            if (method == 2) {
                return this.sqlServer.query(sqlName, value[0], value[1], data).toString();
            }
            if (method == 3) {
                return this.sqlServer.queryHqlTotal(sqlName, data).toString();
            }
            if (method == 4) {
                return this.sqlServer.hqlQuery(sqlName, value[0], value[1], data).toString();
            }
            if (method == 5) {
                return this.sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
            }
            return this.sqlServer.querySQL(sqlName).toString();
        });
    }
}

