/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.entity.EntityServer;
import com.aote.rs.LogicService;
import com.aote.sql.AliasTransformer;
import com.aote.util.JsonTransfer;
import com.aote.util.dialect.DataSourceDialect;
import com.aote.util.dialect.MySQLDialect;
import com.aote.util.dialect.OracleDialect;
import com.aote.util.dialect.SqlServerDialect;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SqlHelper {
    static Logger log = Logger.getLogger(SqlHelper.class);
    public static final DataSourceDialect DATA_SOURCE_DIALECT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray query(Session session, String sql) {
        JSONArray array = new JSONArray();
        HibernateSQLCall sqlCall = new HibernateSQLCall(sql, 0, 9999999);
        sqlCall.transformer = AliasTransformer.INSTANCE;
        long begin = System.currentTimeMillis();
        try {
            List list = (List)sqlCall.doInHibernate(session);
            for (Map map : list) {
                JSONObject json = JsonTransfer.MapToJson(map);
                array.put((Object)json);
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
        finally {
            long end = System.currentTimeMillis();
            log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}"));
        }
    }

    public static JSONArray query(Session session, String sql, int pageNo, int pageSize, boolean isNoLog) throws Exception {
        JSONArray reviewArray;
        JSONArray array = new JSONArray();
        HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
        sqlCall.transformer = AliasTransformer.INSTANCE;
        long begin = System.currentTimeMillis();
        Long reviewKey = LogicService.reviewKey.get();
        JSONObject reviewItem = new JSONObject();
        if (reviewKey != null && (reviewArray = LogicService.reviewCache.get(reviewKey)) != null) {
            reviewItem.put("bTime", begin);
            reviewItem.put("content", (Object)sql);
            reviewItem.put("type", (Object)"sql");
            reviewArray.put((Object)reviewItem);
        }
        try {
            List list = (List)sqlCall.doInHibernate(session);
            for (Map map : list) {
                JSONObject json = JsonTransfer.MapToJson(map);
                array.put((Object)json);
            }
            reviewItem.put("status", 0);
            JSONArray jSONArray = array;
            return jSONArray;
        }
        catch (Exception e) {
            reviewItem.put("status", -1);
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            if (!isNoLog) {
                log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}"));
            }
            reviewItem.put("eTime", end);
            reviewItem.put("constTime", end - begin);
        }
    }

    public static JSONArray query(Session session, String sql, int pageNo, int pageSize) throws Exception {
        return SqlHelper.query(session, sql, pageNo, pageSize, false);
    }

    public static JSONArray hqlQuery(Session session, String sql) throws Exception {
        JSONArray array = new JSONArray();
        HibernateHQLCall sqlCall = new HibernateHQLCall(sql, 0, 9999999);
        long begin = System.currentTimeMillis();
        List list = (List)sqlCall.doInHibernate(session);
        long end = System.currentTimeMillis();
        log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}"));
        for (Map map : list) {
            JSONObject json = JsonTransfer.MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray hqlQuery(Session session, String sql, int pageNo, int pageSize) throws Exception {
        JSONArray array = new JSONArray();
        HibernateHQLCall sqlCall = new HibernateHQLCall(sql, pageNo, pageSize);
        long begin = System.currentTimeMillis();
        try {
            List list = (List)sqlCall.doInHibernate(session);
            for (Map map : list) {
                JSONObject json = JsonTransfer.MapToJson(map);
                array.put((Object)json);
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
        finally {
            long end = System.currentTimeMillis();
            log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int bulkSQLUpdate(Session session, String sql) {
        SQLQuery queryObject = session.createSQLQuery(DATA_SOURCE_DIALECT.getSql(sql));
        long begin = System.currentTimeMillis();
        try {
            int n = queryObject.executeUpdate();
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            log.debug((Object)("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sql + "\n}"));
        }
    }

    static {
        String dialect = EntityServer.findDialect();
        DATA_SOURCE_DIALECT = dialect.equals("SqlServer") ? new SqlServerDialect() : (dialect.equals("Oracle") ? new OracleDialect() : new MySQLDialect());
    }

    static class HibernateHQLCall
    implements HibernateCallback {
        String sql;
        int page;
        int rows;
        ResultTransformer transformer = null;

        public HibernateHQLCall(String sql, int page, int rows) {
            this.sql = sql;
            this.page = page;
            this.rows = rows;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.sql);
            if (this.transformer != null) {
                q.setResultTransformer(this.transformer);
            }
            try {
                return q.setFirstResult(this.page * this.rows).setMaxResults(this.rows).list();
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }

    public static class HibernateSQLCall
    implements HibernateCallback {
        String sql;
        int page;
        int rows;
        public ResultTransformer transformer = null;

        public HibernateSQLCall(String sql, int page, int rows) {
            this.sql = DATA_SOURCE_DIALECT.getSql(sql);
            this.page = page;
            this.rows = rows;
        }

        public Object doInHibernate(Session session) {
            SQLQuery q = session.createSQLQuery(this.sql);
            if (this.transformer != null) {
                q.setResultTransformer(this.transformer);
            }
            try {
                return q.setFirstResult(this.page * this.rows).setMaxResults(this.rows).list();
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

