/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsMapper;
import com.aote.redis.RedisUtil;
import com.aote.util.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceHelper {
    public static CACHE_MODE mode = CACHE_MODE.DEBUG;
    private static final ConcurrentHashMap<String, String> CACHE_LOGIC_MAP = new ConcurrentHashMap(10);
    private static final ConcurrentHashMap<String, String> CACHE_SQL_MAP = new ConcurrentHashMap(10);
    private static final ConcurrentHashMap<String, String> CACHE_PATH_MAP = new ConcurrentHashMap(10);
    @Autowired
    private QueryParamsMapper queryParamsMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String fileName) throws FileNotFoundException, IOException {
        String result;
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            String line;
            if (!fileName.startsWith("/")) {
                fileName = "/" + fileName;
            }
            if (null == (inputStream = ResourceHelper.class.getResourceAsStream(fileName))) {
                throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
            }
            br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            result = sb.toString();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    public static InputStream getStream(String fileName) throws FileNotFoundException, IOException {
        InputStream inputStream = null;
        Object br = null;
        if (!fileName.startsWith("/")) {
            fileName = "/" + fileName;
        }
        if (null == (inputStream = ResourceHelper.class.getResourceAsStream(fileName))) {
            throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
        }
        return inputStream;
    }

    public static String getString(InputStream input) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\r\n");
        }
        String result = sb.toString();
        return result;
    }

    public static Object getString(ResourceType resourceType, String alias, String fileName) throws FileNotFoundException, IOException {
        switch (resourceType) {
            case LOGIC: {
                if (mode == CACHE_MODE.NORMAL && CACHE_LOGIC_MAP.containsKey(alias)) {
                    return CACHE_LOGIC_MAP.get(alias);
                }
                String sourceStr = ResourceHelper.getString(fileName);
                sourceStr = sourceStr.replace("\r\n", "\n");
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_LOGIC_MAP.put(alias, sourceStr);
                }
                return sourceStr;
            }
            case SQL: {
                if (mode == CACHE_MODE.NORMAL && CACHE_SQL_MAP.containsKey(alias)) {
                    return CACHE_SQL_MAP.get(alias);
                }
                String source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_SQL_MAP.put(alias, source);
                }
                return source;
            }
            case PATH: {
                if (mode == CACHE_MODE.NORMAL && CACHE_PATH_MAP.containsKey(alias)) {
                    return CACHE_PATH_MAP.get(alias);
                }
                String source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_PATH_MAP.put(alias, source);
                }
                return source;
            }
            case QUERY_PARAMS: {
                RedisUtil redisUtil = RedisUtil.getInstance();
                Object compileSource = redisUtil.get("QP_" + alias);
                if (compileSource != null) {
                    return new JSONObject(compileSource.toString());
                }
                throw new RuntimeException("\u672a\u627e\u5230\u540d\u4e3a" + alias + "\u7684\u67e5\u8be2\u914d\u7f6e");
            }
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
    }

    public static void clearLogicCache() {
        CACHE_LOGIC_MAP.clear();
    }

    public static void clearSqlCache() {
        CACHE_SQL_MAP.clear();
    }

    public static void clearPathCache() {
        CACHE_PATH_MAP.clear();
    }

    public void clearQueryParamsCache() {
        RedisUtil redisUtil = RedisUtil.getInstance();
        if (redisUtil != null) {
            redisUtil.lock("QUERY_PARAMS_IS_LOADED", () -> redisUtil.set("QUERY_PARAMS_IS_LOADED", "0"));
            this.queryParamsMapper.load();
        }
    }

    public static enum CACHE_MODE {
        NORMAL,
        DEBUG;

    }
}

