/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.exception.FileNotFoundException;
import com.aote.manager.DatabaseServer;
import com.aote.manager.LogicServer;
import com.aote.manager.SQLServer;
import com.aote.manager.VueServer;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Path(value="manager")
@Component
public class ManagerService {
    static Logger log = Logger.getLogger(ManagerService.class);

    @GET
    @Path(value="database")
    public String getDatabase() {
        DatabaseServer server = new DatabaseServer();
        return server.getDatabases().toString();
    }

    @GET
    @Path(value="sql")
    public String getSQL() {
        SQLServer server = new SQLServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="logic")
    public String getLogic() {
        LogicServer server = new LogicServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="vue")
    public String getVue() {
        VueServer server = new VueServer();
        return server.getData().toString();
    }

    @GET
    @Path(value="config")
    public String getConfig() {
        String result = null;
        try {
            result = ResourceHelper.getString("systemConfig.json");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("systemConfig\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        result = result.replaceAll("#[^\n]*", "");
        return result;
    }
}

