/*
 * Decompiled with CFR 0.152.
 */
package com.aote.config;

import com.aote.exception.FileNotFoundException;
import com.aote.util.other.JsonTools;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SystemConfig {
    private static final Logger LOGGER = Logger.getLogger(SystemConfig.class);
    public static final String CONFIG_PATH = "systemConfig.json";
    private static volatile boolean isLoaded = false;

    private static void load() {
        if (!isLoaded) {
            isLoaded = true;
            if (SystemConfig.class.getClassLoader().getResource(CONFIG_PATH) != null) {
                JSONObject params = JsonTools.readJsonFile(CONFIG_PATH);
                JSONObject system = params.getJSONObject("system");
                if (!system.has("webAppName")) {
                    throw new RuntimeException("systemConfig.json\u4e2d\u670d\u52a1\u5e94\u7528\u6a21\u5757\u540d\u53c2\u6570[system:webAppName]\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\u8be5\u53c2\u6570\u4e3aweb\u5e94\u7528\u540d\u79f0\uff0c\u5982revenue,webmeter\u7b49");
                }
                System.webAppName = system.getString("webAppName");
                if (system.has("proxyUrl")) {
                    System.proxyUrl = system.getString("proxyUrl");
                }
                if (system.has("ldapUrl")) {
                    System.ldapUrl = system.getString("ldapUrl");
                }
                JSONObject persistenceLog = params.getJSONObject("persistenceLog");
                PersistenceLog.isEnabled = persistenceLog.optBoolean("isEnabled", false);
                if (PersistenceLog.isEnabled.booleanValue()) {
                    LOGGER.info((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5f00\u542f\uff0c\u5982\u9700\u5173\u95ed\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3afalse.");
                } else {
                    LOGGER.warn((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5173\u95ed\uff0c\u5982\u9700\u5f00\u542f\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3atrue.");
                }
                JSONObject redis = params.getJSONObject("redis");
                if (!redis.has("hostName")) {
                    LOGGER.warn((Object)"Redis\u672a\u914d\u7f6e\uff0c\u90e8\u5206\u529f\u80fd\u5c06\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                } else {
                    Redis.hostName = redis.getString("hostName");
                    if (redis.has("password")) {
                        Redis.password = redis.getString("password");
                    }
                }
                if (!redis.has("registerUrl")) {
                    LOGGER.warn((Object)"\u4e1a\u52a1redis\u6ce8\u518c\u5730\u5740\u672a\u914d\u7f6e\uff0c\u90e8\u5206\u529f\u80fd\u5c06\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528");
                } else {
                    Redis.registerUrl = redis.getString("registerUrl");
                }
                JSONObject resources = params.getJSONObject("resources");
                if (!resources.has("fileRootPath")) {
                    LOGGER.warn((Object)("systemConfig.json\u4e2d\u8d44\u6e90\u6839\u76ee\u5f55\u53c2\u6570[resources:fileRootPath]\u4e0d\u5b58\u5728\uff0c\u4ee5\u6309\u7167\u7f3a\u7701\u503c[D:/" + System.webAppName + "Res]\u914d\u7f6e"));
                }
                Resources.fileRootPath = resources.optString("fileRootPath", "D:/" + System.webAppName + "Res");
                if (resources.has("extraPaths")) {
                    Resources.extraPaths = resources.getJSONObject("extraPaths");
                }
                SubClass.subClassArray = params.optJSONArray("subclass");
                JSONObject dataSecurity = params.optJSONObject("dataSecurity");
                if (Optional.ofNullable(dataSecurity).isPresent()) {
                    DataSecurity.enableDataEncryption = dataSecurity.optBoolean("enableDataEncryption", false);
                    DataSecurity.aesKey = persistenceLog.optString("aesKey");
                    DataSecurity.injectionCheck = dataSecurity.optBoolean("injectionCheck", false);
                } else {
                    DataSecurity.enableDataEncryption = false;
                    DataSecurity.injectionCheck = false;
                }
            } else {
                throw new FileNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6systemConfig.json\u4e0d\u5b58\u5728", CONFIG_PATH);
            }
        }
    }

    public static class DataSecurity {
        private static Boolean enableDataEncryption;
        private static String aesKey;
        private static Boolean injectionCheck;

        public static boolean getEnableDataEncryption() {
            return enableDataEncryption;
        }

        public static String getAesKey() {
            return aesKey;
        }

        public static boolean hasAesKey() {
            return aesKey != null;
        }

        public static boolean getInjectionCheck() {
            return injectionCheck;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class SubClass {
        private static JSONArray subClassArray;

        public static JSONArray getSubClassArray() {
            return subClassArray;
        }

        public static boolean hasSubClassArray() {
            return subClassArray != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Resources {
        private static String fileRootPath;
        private static JSONObject extraPaths;

        public static String getFileRootPath() {
            return fileRootPath;
        }

        public static String getExtraPath(String key) {
            return extraPaths.getString(key);
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Redis {
        private static String hostName;
        private static String password;
        private static String registerUrl;

        public static String getHostName() {
            return hostName;
        }

        public static boolean hasHostName() {
            return hostName != null;
        }

        public static String getPassword() {
            return password;
        }

        public static boolean hasPassword() {
            return password != null;
        }

        public static String getRegisterUrl() {
            return registerUrl;
        }

        public static boolean hasRegisterUrl() {
            return registerUrl != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class PersistenceLog {
        private static Boolean isEnabled;

        public static Boolean getEnabled() {
            return isEnabled;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class System {
        private static String webAppName;
        private static String proxyUrl;
        private static String ldapUrl;

        public static String getWebAppName() {
            return webAppName;
        }

        public static String getProxyUrl() {
            return proxyUrl;
        }

        public static boolean hasProxyUrl() {
            return proxyUrl != null;
        }

        public static String getLdapUrl() {
            return ldapUrl;
        }

        public static boolean hasLdapUrl() {
            return ldapUrl != null;
        }

        static {
            SystemConfig.load();
        }
    }
}

