package com.aote.rs;

import com.aote.config.SystemConfig;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.module.ModuleMapper;
import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.LdapHelper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@Path("product")
@Singleton
@Component
public class ProductService {
	static Logger log = Logger.getLogger(ProductService.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private SqlServer sqlServer;

	@Autowired
	private PathServer pathServer;

	@Autowired
	private LogicServer logicServer;

	public void setShouldInit(boolean shouldInit) {
		this.shouldInit = shouldInit;
	}

	// 是否加载初始数据，手机测试时，不用加载
	private boolean shouldInit = true;

	/**
	 * 取正在运行系统的参数，存放到c:/param.json中
	 * @return 无
	 * @throws Exception
	 */
	@POST
	@Transactional
	@Path("getparam")
	public String xtGetParam() throws Exception {
		// 执行path查询，找到所有参数
		String path = "t_parameter.(**)";
		JSONArray array = pathServer.query(path);
		// 获取单值表
		String getSingle = "t_singlevalue.(*)";
		JSONArray singles = pathServer.query(getSingle);
		// 打开c:/param.json
		Writer writer = new OutputStreamWriter(new FileOutputStream("d:/param.json"), StandardCharsets.UTF_8);
		writer.write("{\n");

		// 把查询到的json转换成要写的json对象
		for (Object o : array) {
			JSONObject param = (JSONObject)o;
			String key = param.getString("name");
			JSONArray paramValue = new JSONArray();
			JSONArray paramArray = param.getJSONArray("f_paramvalues");
			for(Object obj : paramArray) {
				JSONObject paramJson = (JSONObject)obj;
				String value = paramJson.getString("name");
				paramValue.put(value);
			}
			// 输出一个参数值
			String result = "\t\"" + key + "\":" + paramValue.toString() + ",\n";
			writer.write(result);
		}
		for (Object o : singles) {
			JSONObject param = (JSONObject)o;
			String key = param.getString("name");
			String value = param.getString("value");
			// 输出一个参数值
			String result = "\t\"" + key + "\":" + value + ",\n";
			writer.write(result);
		}

		writer.write("}\n");
		writer.close();
		return "";
	}

	@PostConstruct
	public void init() {
		try {
			if(shouldInit) {
				//sessionPool.getSession();
				entityServer.initParam();
				// 加载模块功能
				this.loadFunctions();
			}
		} catch (Exception e) {
			log.warn(e.toString());
		}
	}

	/**
	 * 执行初始化业务逻辑
	 */
	private void runInitialLogic(String module) {
		try {
			if (LogicMapper.getLogic(module+"Install") == null) {
				log.warn("无模块初始化业务逻辑，不对模块进行初始化！ module=" + module);
				return;
			}
			JSONObject params = new JSONObject();
			params.put("data",new JSONObject());
			logicServer.run(module+"Install",params);
		} catch (RuntimeException e) {
			throw e;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 加载模块功能
	 */
	public void loadFunctions() {
		// 对每一个模块，调用加载功能过程
		Map<String, Map<String, String>> map = ModuleMapper.getMap();
		for(String key : map.keySet()) {
			//加载模块功能
			innerLoadFunctions(key);
			//执行初始化业务逻辑
			runInitialLogic(key);
		}
	}

	/**
	 * 加载某一个模块功能
	 * @param module
	 */
	private void innerLoadFunctions(String module) {
		try {
			// module要添加路径分隔符
			if (!"".equals(module)) {
				module += "/";
			}
			if (ResourceHelper.class.getResourceAsStream("/" + module + "function.json") == null) {
				log.warn("无function.json文件，不对功能进行初始化！ module=" + module);
				return;
			}
			// 获取功能配置文件
			String strConfig = ResourceHelper.getString(module + "function.json");
			JSONObject json = new JSONObject(strConfig);
			// 得到ldap服务地址，将通过ldap服务添加功能
			if (!SystemConfig.System.hasLdapUrl()) {
				log.error("systemConfig.json无ldap配置，无法初始化功能！module=" + module);
				return;
			}
			String ldap = SystemConfig.System.getLdapUrl();

			// 查询功能模块节点
			String funcRootStr = LdapHelper.search(ldap, "{source: 'root.getChildByName($功能模块$)', userid: ''}");
			//JSONArray funcs = new JSONArray(funcRootStr);
			//JSONObject funcRoot = funcs.getJSONObject(0);
			JSONObject funcRoot = new JSONObject(funcRootStr);
			String parentid = funcRoot.getString("id");

			log.info("开始对功能初始化。module=" + module);
			// 取得所有功能列表
			JSONObject functions = json.getJSONObject("functions");
			for (String key : functions.keySet()) {
				// 调用功能增加函数
				JSONObject func = functions.getJSONObject(key);
				this.procOneFunction(key, func, parentid, ldap);
			}
		} catch (RuntimeException e) {
			throw e;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 增加一个功能，如果存在，返回已经存在的功能
	 * @param funcJson: 功能json串，包含子功能
	 * @param parentid: 父功能id
	 * @return 新加功能id
	 */
	private String procOneFunction(String name, JSONObject funcJson, String parentid, String url) {
		try {
			// 从功能串描述中，获取功能自身属性
			JSONObject func = new JSONObject();
			for (String key : funcJson.keySet()) {
				// 如果不是JSON对象，则代表自身属性
				Object obj = funcJson.get(key);
				if (!(obj instanceof JSONObject)) {
					func.put(key, obj);
				}
			}

			// 根据名字看功能是否已经存在
			String str = "{source: 'tool.toList(this.getChildren()).where(row.attributes.get($name$)==$" + name  + "$)', userid: '" + parentid + "'}";
			String result = LdapHelper.search(url, str);
			JSONArray array = new JSONArray(result);
			// 已经存在，不添加。
			String id;
			if (array.length() == 0) {
				func.put("resourcetype", "function");
				func.put("name", name);
				func.put("id", "");
				id = LdapHelper.saveChild(url, parentid, func);
			} else {
				id = array.getJSONObject(0).getString("id");
			}

			// 对功能描述的每一项
			for (String key : funcJson.keySet()) {
				// 如果结果是JSON对象，则代表一个子功能，递归调用处理过程
				Object obj = funcJson.get(key);
				if (obj instanceof JSONObject) {
					JSONObject json = (JSONObject) obj;
					procOneFunction(key, json, id, url);
				}
			}
			return id;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
