/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.transaction.ThreadSession;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SingleTableTool {
    static Logger log = Logger.getLogger(SingleTableTool.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private ThreadSession tSession;
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private SessionFactory factory;

    public static String temporaryName() {
        String name = "LS_" + IdUtil.objectId();
        name = name.toUpperCase();
        return name;
    }

    public static ArrayList<String> temporaryName(int num) {
        ArrayList<String> ls = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            ls.add(SingleTableTool.temporaryName());
        }
        return ls;
    }

    public static String getPlaceholder() {
        return "{}";
    }

    public String createTemporaryTable(String logicConfig, String keyName, String querySql) throws Exception {
        return this.createTemporaryTable(logicConfig, keyName, querySql, null);
    }

    public String createTemporaryTable(String logicConfig, String keyName, String querySql, String tableName) throws Exception {
        try {
            if (tableName == null) {
                tableName = SingleTableTool.temporaryName();
            }
            JSONObject config = (JSONObject)this.logicServer.run(logicConfig, new JSONObject());
            JSONArray json = config.getJSONArray(keyName);
            StringBuilder fields = new StringBuilder();
            StringBuilder fieldsInto = new StringBuilder();
            for (int i = 0; i < json.length(); ++i) {
                AbstractMap.SimpleEntry row = (AbstractMap.SimpleEntry)json.get(i);
                String field = (String)row.getKey();
                JSONObject value = (JSONObject)row.getValue();
                String defaultType = "VARCHAR2(100)";
                if (value.has("type")) {
                    defaultType = value.getString("type");
                }
                fields.append(StrUtil.format((CharSequence)"{} {},", (Object[])new Object[]{field, defaultType}));
                fieldsInto.append(StrUtil.format((CharSequence)"{},", (Object[])new Object[]{field}));
            }
            String fieldStr = StrUtil.removeSuffix((CharSequence)fields, (CharSequence)",");
            String fieldsIntoStr = StrUtil.removeSuffix((CharSequence)fieldsInto, (CharSequence)",");
            String createSqlTem = "CREATE GLOBAL TEMPORARY TABLE {} (\n{}) ON COMMIT PRESERVE ROWS";
            String createSql = StrUtil.format((CharSequence)createSqlTem, (Object[])new Object[]{tableName, fieldStr});
            int i = this.sqlServer.runSQL(createSql);
            String insertSqlTem = "insert into {} ({}) {}";
            String insertSql = StrUtil.format((CharSequence)insertSqlTem, (Object[])new Object[]{tableName, fieldsIntoStr, querySql});
            int i1 = this.sqlServer.runSQL(insertSql);
            log.debug((Object)("\u6267\u884cINSERT\u8bed\u53e5\u7ed3\u679c:" + i1));
            return tableName;
        }
        catch (Exception e) {
            log.debug((Object)"\u521b\u5efa\u4e00\u4e2a\u4e34\u65f6\u8868\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    public JSONObject generateConditions(String logicConfig, JSONObject model) throws Exception {
        try {
            JSONObject result = new JSONObject();
            JSONObject config = (JSONObject)this.logicServer.run(logicConfig, new JSONObject());
            Iterator keys = config.keys();
            while (keys.hasNext()) {
                String next = (String)keys.next();
                JSONArray json = config.getJSONArray(next);
                StringBuilder condition = new StringBuilder("1=1");
                for (int i = 0; i < json.length(); ++i) {
                    JSONObject value;
                    String joint;
                    AbstractMap.SimpleEntry row = (AbstractMap.SimpleEntry)json.get(i);
                    String field = (String)row.getKey();
                    if (!model.has(field) || "".equals(model.get(field)) || "false".equals(joint = (value = (JSONObject)row.getValue()).optString("joint", "= '{}'"))) continue;
                    condition.append(StrUtil.format((CharSequence)(" and {} " + joint), (Object[])new Object[]{field, model.getString(field)}));
                }
                result.put(next, (Object)condition);
            }
            return result;
        }
        catch (Exception e) {
            log.debug((Object)"\u751f\u6210\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }
}

