/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.aote.filter.Config;
import com.aote.filter.ModifyResponseBodyWrapper;
import com.aote.filter.RSAUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseFilter
extends OncePerRequestFilter {
    static Logger log = Logger.getLogger(ResponseFilter.class);
    private static String redispwd;
    public static String regex;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Long startTime = System.currentTimeMillis();
        Object jedis = null;
        ServletOutputStream out = null;
        String url = httpServletRequest.getRequestURI();
        if (!Config.filterCheck(url)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            try {
                ModifyResponseBodyWrapper modifyResponseBodyWrapper = new ModifyResponseBodyWrapper(httpServletResponse);
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)modifyResponseBodyWrapper);
                String oldResponseBody = modifyResponseBodyWrapper.getResponseBody();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(oldResponseBody);
                String loginId = httpServletRequest.getHeader("Token");
                boolean authorization = Config.isAuthorization(loginId);
                log.debug((Object)("\u5f53\u524d\u7528\u6237:" + loginId + ",\u89e3\u654f\u6743\u9650:" + authorization));
                String newResponseBody = matcher.find() && authorization ? ResponseFilter.modifyResponseBody(oldResponseBody, true) : ResponseFilter.modifyResponseBody(oldResponseBody, false);
                httpServletResponse.setContentLength(newResponseBody.getBytes(StandardCharsets.UTF_8).length);
                httpServletResponse.setContentType(httpServletRequest.getContentType());
                byte[] responseBodyData = newResponseBody.getBytes(StandardCharsets.UTF_8);
                out = httpServletResponse.getOutputStream();
                out.write(responseBodyData);
                out.flush();
                Long endTime = System.currentTimeMillis();
                log.debug((Object)("ResponseFilter:" + url + ",\u62e6\u622a\u5668\u8017\u65f6:" + (endTime - startTime)));
            }
            catch (Exception e) {
                log.error((Object)"ResponseFilter\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static String modifyResponseBody(String originalBody, Boolean sensitive) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalBody);
        StringBuffer sb = new StringBuffer(originalBody.length());
        String replacement = "****";
        while (matcher.find()) {
            String match = matcher.group(0);
            if (sensitive.booleanValue()) {
                try {
                    replacement = RSAUtil.aesDecrypt(match.replace("|-", "").replace("-|", ""), "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt");
                }
                catch (Exception e) {
                    log.debug((Object)"\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        regex = "\\|-\\S*?(==|=)-\\|";
    }
}

