package com.aote.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 10:35 2023/4/17
 */
public class DesensitizationTool {
    public static final String KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";

    public static void main(String[] args) throws Exception {
//        String phone = "13976247686";
//        String phoneEncrypt = phoneEncrypt(phone);
//        String idNumber = "32062319690415861X";
//        String idNumberEncrypt = idNumberEncrypt(idNumber);
//        System.out.println("原文" + phone + ",密文:" + phoneEncrypt);
//        System.out.println("原文" + idNumber + ",密文:" + idNumberEncrypt);
//        System.out.println(RSAUtil.aesDecrypt("lgbnCwSb5Nu6P2AGfW8WDg==", KEY));
//        System.out.println(checkID("370102197406202117"));
//        System.out.println(checkPhone("18292552417"));
    }

    public static boolean checkID(String id) {
        String regex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        if (id.matches(regex)) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean checkPhone(String phone) {
        String regex = "^(13[0-9]|14[5-9]|15[012356789]|16[56]|17[0-8]|18[0-9]|19[189])\\d{8}$";
        if (phone.matches(regex)) {
            return true;
        } else {
            return false;
        }
    }

    public static String phoneEncrypt(String phone) throws Exception {
        if (!Config.isDesensitization()) {
            return phone;
        }
        String regex = "(\\d{3})(\\d{4})(\\d{4})";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phone);
        String encrypt = "";
        if (matcher.find()) {
            // 获取第二个分组的值
            String group1 = matcher.group(2);
            encrypt = RSAUtil.aesEncrypt(group1, KEY);
        }
        encrypt = "|-" + encrypt + "-|";
        return phone.replaceAll(regex, "$1" + encrypt + "$3");
    }


    public static String idNumberEncrypt(String idNumber) throws Exception {
        if (!Config.isDesensitization()) {
            return idNumber;
        }
        String regex = "^(\\d*)(\\w{4})$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(idNumber);
        String encrypt = "";
        if (matcher.find()) {
            String group1 = matcher.group(1);
            encrypt = RSAUtil.aesEncrypt(group1, KEY);
        }
        encrypt = "|-" + encrypt + "-|";
        return idNumber.replaceAll(regex, encrypt + "$2");
    }
}
