package com.aote.filter;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

import java.util.Arrays;

/**
 * 读取配置文件
 */
public class Config {
    static Logger log = Logger.getLogger(Config.class);

    /**
     *  参数对象, 用它动态获取数据
     */
    public static PropertiesConfiguration config;

    static {
        try {
            config = new PropertiesConfiguration("Config.properties");
            // 自动重新加载
            config.setReloadingStrategy(new FileChangedReloadingStrategy());
        } catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }


    /**
     * 强制加密检查
     * @param json 参数
     * @param url url
     * @return 结果
     */
    public static boolean encryptionCheck(String json,String url) {
        try {
            log.debug("验证请求: " + url);
            String passUrl = config.getString("passUrl");
            String[] split = passUrl.split("-");
            log.debug("放行的: " + Arrays.toString(split));
            for (int i = 0; i < split.length; i++) {
                if (url.equals(split[i])) {
                    return true;
                }
            }
            return json.contains("oYlL7QwAOFENGsF8RANXCRGB99nXaMsl");
        } catch (Exception e) {
            log.debug("检查加密异常", e);
            throw e;
        }
    }

    /**
     * 检查url是否需要解敏感操作
     * @param url
     * @return true:需要 false:不需要
     */
    public static boolean filterCheck(String url) {
        try {
            String passUrl = config.getString("ResponseFilterUrl");
            String[] split = passUrl.split("-");
            for (int i = 0; i < split.length; i++) {
                if (url.contains(split[i])) {
                    return true;
                }
            }
            return false;
        } catch (Exception e) {
            log.debug("filterCheck检查异常", e);
            throw e;
        }
    }

    /** 解敏用户校验
     */
    public static boolean isAuthorization(String id) {
        for (String item : config.getString("CanDecryptUserId").split("-")) {
            if (item.equals(id)) {
                return true;
            }
        }
        return false;
    }

    // 是否开启脱敏处理
    public static boolean isDesensitization() {
        return config.getBoolean("ResponseFilterSwitch",false);
    }
}
