package com.aote.util;

import com.aote.entity.EntityServer;
import com.aote.rs.LogicService;
import com.aote.sql.AliasTransformer;
import com.aote.util.dialect.DataSourceDialect;
import com.aote.util.dialect.MySQLDialect;
import com.aote.util.dialect.OracleDialect;
import com.aote.util.dialect.SqlServerDialect;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.orm.hibernate4.HibernateCallback;

import java.util.List;
import java.util.Map;

/**
 * SQL辅助类
 */
public class SqlHelper {
	static Logger log = Logger.getLogger(SqlHelper.class);

	/**
	 * 数据源方言兼容性组件
	 */
	public static final DataSourceDialect DATA_SOURCE_DIALECT;


	static {
		// 初始化数据源方言兼容性组件
		if(EntityServer.dialect.equals(EntityServer.DIALECT_SQLSERVER)){
			DATA_SOURCE_DIALECT = new SqlServerDialect();
		} else if(EntityServer.dialect.equals(EntityServer.DIALECT_ORACLE)){
			DATA_SOURCE_DIALECT = new OracleDialect();
		} else {
			DATA_SOURCE_DIALECT = new MySQLDialect();
		}
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql) throws Exception {
		return query(null, session, sql);
	}

	public static JSONArray query(String name, Session session, String sql) throws Exception {
		return query(name, session, sql, 0, 9999999);
	}

	public static JSONArray query(Session session, String sql, int pageNo,
								  int pageSize) throws Exception {
		return query(null, session, sql, pageNo, pageSize);
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(String name, Session session, String sql, int pageNo,
								  int pageSize) throws Exception {
		JSONArray array = new JSONArray();
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
		sqlCall.transformer = AliasTransformer.INSTANCE;
		long begin = System.currentTimeMillis();
		// 记录业务执行流程堆栈
		String reviewKey = LogicService.reviewKey.get();
		JSONObject reviewItem = new JSONObject();
		if(reviewKey != null) {
			JSONArray reviewArray = LogicService.reviewCache.get(reviewKey);
			if(reviewArray != null) {
				if(name != null){
					reviewItem.put("name", name);
				}
				reviewItem.put("bTime", begin);
				reviewItem.put("content", sql);
				reviewItem.put("type", "sql");
				reviewArray.put(reviewItem);
			}
		}
		try {
			List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
					.doInHibernate(session);
			for (Map<String, Object> map : list) {
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				array.put(json);
			}
			reviewItem.put("status", 0);
			return array;
		} catch (Exception e){
			reviewItem.put("status", -1);
			throw e;
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
			reviewItem.put("eTime", end);
			reviewItem.put("constTime", end - begin);
		}
	}

	/**
	 * hql基本查询
	 * @param session
	 * @param sql
	 * @return JSONArray
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session,String sql) throws Exception
	{
		JSONArray array=new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, 0, 9999999);

		long begin = System.currentTimeMillis();
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		long end = System.currentTimeMillis();
		log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
		for (Map<String, Object> map : list) {
			JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
			array.put(json);
		}
		return array;
	}
	/**
	 * hql分页查询
	 * @param session
	 * @param sql
	 * @param pageNo
	 * @param pageSize
	 * @return  JSONArray
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session, String sql, int pageNo,
									 int pageSize) {
		JSONArray array = new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, pageNo, pageSize);

		long begin = System.currentTimeMillis();
		try {
			List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
					.doInHibernate(session);
			for (Map<String, Object> map : list) {
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				array.put(json);
			}
			return array;
		} catch (Exception e) {
			throw new RuntimeException(e);
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
		}
	}

	public static int bulkSQLUpdate(Session session, String sql) {
		Query queryObject = session.createSQLQuery(DATA_SOURCE_DIALECT.getSql(sql));
		long begin = System.currentTimeMillis();
		// 记录业务执行流程堆栈
		String reviewKey = LogicService.reviewKey.get();
		JSONObject reviewItem = new JSONObject();
		if(reviewKey != null) {
			JSONArray reviewArray = LogicService.reviewCache.get(reviewKey);
			if(reviewArray != null) {
				reviewItem.put("bTime", begin);
				reviewItem.put("content", sql);
				reviewItem.put("type", "sql");
				reviewArray.put(reviewItem);
			}
		}
		try {
			reviewItem.put("status",0);
			return queryObject.executeUpdate();
		} catch (Exception e) {
			reviewItem.put("status",-1);
			throw e;
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sql + "\n}");
			reviewItem.put("eTime", end);
			reviewItem.put("constTime", end - begin);
		}
	}

	@SuppressWarnings("rawtypes")
	public static class HibernateSQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		public ResultTransformer transformer = null;

		public HibernateSQLCall(String sql, int page, int rows) {
			this.sql = DATA_SOURCE_DIALECT.getSql(sql);
			this.page = page;
			this.rows = rows;
		}

		@Override
		public Object doInHibernate(Session session) {
			Query q = session.createSQLQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				return q.setFirstResult(page * rows).setMaxResults(rows).list();
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}
	@SuppressWarnings("rawtypes")
	static class HibernateHQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		ResultTransformer transformer = null;

		public HibernateHQLCall(String sql, int page, int rows) {
			this.sql = sql;
			this.page = page;
			this.rows = rows;
		}

		@Override
		public Object doInHibernate(Session session) {
			Query q = session.createQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				return q.setFirstResult(page * rows).setMaxResults(rows).list();
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}
}
