package com.aote.rs;

import com.af.plugins.AESUtil;
import com.aote.exception.ExceptionLogManage;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * 提供sql查询服务
 */
@Path("sql")
@Component
@Transactional
public class SqlService {
	static Logger log = Logger.getLogger(SqlService.class);

	static Logger reviewLog = Logger.getLogger("reviewLog");

	@Autowired
	private SqlServer sqlServer;

	@Autowired
	private ExceptionLogManage exceptionLogManage;

	/**
	 * 获取SQL语句的合计执行结果
	 *
	 * @param name
	 *            : sql语句名
	 * @param str
	 *            : sql语句执行参数
	 */
	@POST
	@Path("{name}/n")
	public String txgetTotalCnt(@PathParam("name") String name, String str, @Context HttpServletRequest request)
			throws Exception {
		try {
			setRequestId(request);
			return sqlEncrypt(name, str, 1);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/"+name+"/n");
			throw ex;
		}
	}
	public String txgetTotalCnt(String name, String str)
			throws Exception {
		return txgetTotalCnt(name, str, null);
	}

	/**
	 * 执行sql,对sql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("{name}")
	public String txExecute(@PathParam("name") String name,
							@QueryParam("pageNo") int pageNo,
							@QueryParam("pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
		try {
			setRequestId(request);
			return sqlEncrypt(name, str, 2, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/"+name);
			throw ex;
		}
	}
	public String txExecute(String name, int pageNo,int pageSize, String str) throws Exception {
		return txExecute(name, pageNo, pageSize, str, null);
	}

	/**
	 * 获取HQL语句的合计执行结果
	 *
	 * @param name
	 *            : hql语句名
	 * @param str
	 *            : hql语句执行参数
	 */
	@POST
	@Path("hql/{name}/n")
	public String txHqlgetTotalCnt(@PathParam("name") String name, String str, @Context HttpServletRequest request)
			throws Exception {
		try {
			setRequestId(request);
			return sqlEncrypt(name, str, 3);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name+"/n");
			throw ex;
		}
	}
	public String txHqlgetTotalCnt(String name, String str)
			throws Exception {
		return txHqlgetTotalCnt(name, str, null);
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 */
	@POST
	@Path("hql/{name}")
	public String txHqlExecute(@PathParam("name") String name,
							   @QueryParam("pageNo") int pageNo,
							   @QueryParam("pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
		try {
			setRequestId(request);
			return sqlEncrypt(name, str, 4, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name);
			throw ex;
		}
	}
	public String txHqlExecute(String name,
							   int pageNo,
							   int pageSize,
							   String str) throws Exception {
		return txHqlExecute(name, pageNo, pageSize, str, null);
	}

	/**
	 * 执行hql,对hql中的参数进行替换 pageNo - 页号，默认为1 pageSize - 每页个数，默认为1000
	 * 取消大于1000时限制1000的条件
	 */
	@POST
	@Path("hql/{name}/all")
	public String txHqlExecuteAll(@PathParam("name") String name,
								  @QueryParam("pageNo") int pageNo,
								  @QueryParam("pageSize") int pageSize, String str, @Context HttpServletRequest request) throws Exception {
		try {
			setRequestId(request);
			return sqlEncrypt(name, str, 5, pageNo, pageSize);
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			exceptionLogManage.writeError(ex,name,"/rs/sql/hql/"+name+"/all");
			throw ex;
		}
	}
	public String txHqlExecuteAll(String name,int pageNo,int pageSize, String str) throws Exception {
		return txHqlExecuteAll(name,pageNo,pageSize,str, null);
	}

	private void setRequestId(HttpServletRequest request){
		//加入请求头数据
		if(request != null){
			Enumeration headerNames = request.getHeaderNames();
			if(headerNames != null){
				while (headerNames.hasMoreElements()){
					String temp = headerNames.nextElement().toString();
					if(temp.equals("request_id")){
						LogicService.reviewKey.set(request.getHeader("request_id"));
						return;
					}
				}
			}
		}
	}

	/**
	 * 封装sql加解密
	 * @param sqlName sql名
	 * @param param	参数
	 * @param method 区分调用
	 * @param value	接收分页的两个参数
	 * @return
	 */
	private String sqlEncrypt(String sqlName, String param, int method, int ... value)throws Exception{
		JSONObject reviewObj = null;
		String requestId = LogicService.reviewKey.get();
		long begin = System.currentTimeMillis();
		try {
			JSONObject paramJson = new JSONObject(param);
			JSONObject configJson = JsonHelper.getConfig();
			//验证
			Util.checkEncry(paramJson, configJson);
			//如果不需要加密，进入default正常执行
			if (!paramJson.has("aoteEncrypt")) {
				paramJson.put("aoteEncrypt", "default");
			}
			//sql注入标志位
			boolean sqlInject = false;
			if (configJson.has("sqlInject")) {
				sqlInject = configJson.getBoolean("sqlInject");
			}
			if(requestId != null) {
				LogicService.reviewCache.put(requestId, new JSONArray());
				reviewObj = new JSONObject();
				reviewObj.put("status", 0);
			}
			//判断解密方式
			switch (paramJson.getString("aoteEncrypt")) {
				case "AES":
					// 数据解密
					String encryKey = configJson.getString("encryKey");
					String data = paramJson.getString("data");
					String decryData = AESUtil.decrypt(data, encryKey);
					// 验证参数是否合法
					if (sqlInject) {
						ParamFilter.checkSqlJsonStr(decryData);
					}
					if (method == 1) {
						return AESUtil.encrypt(sqlServer.queryTotal(sqlName, decryData).toString(), encryKey);
					} else if (method == 2) {
						return AESUtil.encrypt(sqlServer.query(sqlName, value[0], value[1], decryData).toString(), encryKey);
					} else if (method == 3) {
						return AESUtil.encrypt(sqlServer.queryHqlTotal(sqlName, decryData).toString(), encryKey);
					} else if (method == 4) {
						return AESUtil.encrypt(sqlServer.hqlQuery(sqlName, value[0], value[1], decryData).toString(), encryKey);
					} else {
						return AESUtil.encrypt(sqlServer.hqlQueryAll(sqlName, value[0], value[1], decryData).toString(), encryKey);
					}
				default:
					// 验证参数是否合法
					if (sqlInject) {
						ParamFilter.checkSqlJsonStr(param);
					}
					if (method == 1) {
						return sqlServer.queryTotal(sqlName, param).toString();
					} else if (method == 2) {
						return sqlServer.query(sqlName, value[0], value[1], param).toString();
					} else if (method == 3) {
						return sqlServer.queryHqlTotal(sqlName, param).toString();
					} else if (method == 4) {
						return sqlServer.hqlQuery(sqlName, value[0], value[1], param).toString();
					} else {
						return sqlServer.hqlQueryAll(sqlName, value[0], value[1], param).toString();
					}
			}
		} catch (Exception ex){
			if(reviewObj != null) {
				reviewObj.put("status", -1);
			}
			throw ex;
		} finally {
			if(reviewObj != null) {
				long end = System.currentTimeMillis();
				reviewObj.put("bTime", begin);
				reviewObj.put("eTime", end);
				reviewObj.put("constTime", end - begin);
				reviewObj.put("type", "onlySql");
				reviewObj.put("items", LogicService.reviewCache.get(requestId));
				reviewObj.put("requestId", requestId);
				reviewLog.debug(reviewObj + ",");
				LogicService.reviewKey.remove();
				LogicService.reviewCache.remove(requestId);
			}
		}
	}
}
