package com.aote.timer;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import com.aote.logic.LogicServer;

public class CommonCallBack implements ICallBack {

	@Autowired
	private LogicServer logicServer;

	private List<String> logics;
	
	@Override
	public void runCallBack(List<JSONArray> listArr) {
		for (int i = 0; i < listArr.size(); i++) {
			JSONArray arr = listArr.get(i);
			JSONObject jo = new JSONObject();
			jo.put("arr", arr);
			Object o = null;
			try {
				o = logicServer.run(logics.get(i), jo);
			} catch (Exception e) {
				e.printStackTrace();
			}
			if (o != null) {
				System.out.println(o.getClass().getSimpleName());
			}
			
		}

	}

	public List<String> getLogics() {
		return logics;
	}

	public void setLogics(List<String> logics) {
		this.logics = logics;
	}

}
