package com.aote.sql;

import com.aote.ThreadResource;
import com.aote.logic.LogicMapper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * sql映射器
 * @author LGY
 *
 */
public class SqlMapper {

	static Logger log = Logger.getLogger(SqlMapper.class);
	
	private static Map<String, Map<String, String>> map;
	
	public static synchronized String getSql(String alias)
	{
		if(map == null) {
            loadMap();
        }
		if(map.containsKey(alias)) {String result = getSqlByUser(alias);
			if(result != null) {
				return result;
			}
			return map.get(alias).get("path");
		}
		else {
            return null;
        }
	}
	public static synchronized Map<String, Map<String, String>> getMap() {
		if (map == null) {
            loadMap();
        }
		return SqlMapper.map;
	}

	public  static String getSqlByUser(String alias){
		//获取登陆用户用户名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		//查看对应目录下是否存在相关sql
		String path = "/" + dir + "/sqls/" +alias + ".sql";
		if (SqlMapper.class.getResource(path) != null) {
			return path;
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		SAXReader reader = new SAXReader();
		InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator it = root.elementIterator("sql"); it.hasNext();) {
					Element elm = (Element) it.next();
					Map<String, String> logic = new HashMap<>();
					String alias = elm.attribute("alias").getValue();
					logic.put("alias", alias);
					String path = elm.attribute("path").getValue();
					logic.put("path", "sqls/" + path);
					String mobile = elm.attributeValue("mobile");
					logic.put("mobile", mobile);
					map.put(alias, logic);
					
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	private static void parseModule (InputStream input) throws Exception{
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			putMap(name, reader, null);
			for (Iterator children = elm.elementIterator("module"); children.hasNext();) {
				Element childElm = (Element) children.next();
				String childname = childElm.attribute("name").getValue();
				putMap(childname, reader, name);
			}
		}
	}
	
	private static void putMap(String name, SAXReader reader, String parent) throws Exception {
		
		InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/sql.xml" : parent+"/"+name + "/sql.xml");
		if (moduleSql != null) {
			Document docSql = reader.read(moduleSql);
			Element rootSql = docSql.getRootElement();
			for (Iterator item = rootSql.elementIterator("sql"); item.hasNext();) {
				Element elmment = (Element) item.next();
				Map<String, String> logic = new HashMap<>();
				String aliasSql = elmment.attribute("alias").getValue();
				logic.put("alias", aliasSql);
				String pathSql = elmment.attribute("path").getValue();
				logic.put("path", (parent == null ? name + "/sqls/" : parent + "/" + name + "/sqls/")+ pathSql);
				String mobile = elmment.attributeValue("mobile");
				logic.put("mobile", mobile);
				// 验证别名是否重复
				if (map.containsKey(aliasSql)){
					throw new Exception("别名"+ aliasSql + "已存在");
				}
				map.put(aliasSql, logic);
//				map.put(aliasSql, (parent == null ? name + "/sqls/" : parent + "/" + name + "/sqls/")+ pathSql);
			}
		}
	}
	
	public void main(String[] args) {
		SqlMapper.loadMap();
		for(String key : map.keySet()) {
            System.out.println(key);
        }
	}
}
