package com.aote.path;

import com.af.path.ISqlRunner;
import com.aote.sql.AliasTransformer;
import com.aote.util.SqlHelper.HibernateSQLCall;
import org.hibernate.Session;

import java.util.List;
import java.util.Map;

// 分页sql语句执行器
public class PagedSqlRunner implements ISqlRunner {
	// 页号
	int pageNo;
	// 每页尺寸
	int pageSize;
	
	public PagedSqlRunner(int pageNo, int pageSize) {
		this.pageNo = pageNo;
		this.pageSize = pageSize;
	}
	
	@Override
	public List<Map<String, Object>> queryToList(Session session, String sql) {
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, this.pageNo, this.pageSize);
		sqlCall.transformer = AliasTransformer.INSTANCE;
		return (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
	}
}
