package com.aote.util;

import com.aote.rs.mapper.WebException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

/**
 * ldap访问辅助类
 */
public class LdapHelper {

    /**
     * 调用ldap的search服务
     * @param url: ldap的url
     * @param str: search表达式
     */
    public static String search(String url, String str) throws Exception {
        String path = url + "/rs/search";
        HttpPost postMethod = new HttpPost(path);
        StringEntity se = new StringEntity(str, "UTF-8");
        postMethod.setEntity(se);
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(postMethod);
        int code = response.getStatusLine().getStatusCode();
        String actual = EntityUtils.toString(response.getEntity(), "UTF8");
        // 出错，抛出web异常
        if (code != 200) {
            throw new WebException(code, actual);
        }
        return actual;
    }

    /**
     * 给节点增加子节点, 如果属性中有id，表示更新
     * @param url
     * @param data
     * @return
     */
    public static String saveChild(String url, String parentid, JSONObject data) throws Exception  {
        // 把父节点添加到子节点属性中
        data.put("parentid", parentid);
        // 组织服务所需json结构
        JSONObject param = new JSONObject();
        param.put("data",  data);

        String path = url + "/rs/data/save";
        HttpPost postMethod = new HttpPost(path);
        StringEntity se = new StringEntity(param.toString(), "UTF-8");
        postMethod.setEntity(se);
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(postMethod);
        int code = response.getStatusLine().getStatusCode();
        String actual = EntityUtils.toString(response.getEntity(), "UTF8");
        // 出错，抛出web异常
        if (code != 200) {
            throw new WebException(code, actual);
        }
        return actual;
    }
}
