/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelUtil {
    private static Logger logger = Logger.getLogger(ExcelUtil.class);
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    private Workbook theBook;
    private Sheet lastSheet;
    private boolean hasTemplate;
    private String filePath;
    private int firstDataRow;
    private int firstDataCol;

    public void createBook(String templateName, String filePath) throws Exception {
        this.filePath = filePath;
        boolean bl = this.hasTemplate = templateName != null && !templateName.isEmpty();
        if (this.hasTemplate) {
            this.initWork(templateName);
        } else {
            this.theBook = filePath.endsWith(XLSX) ? new XSSFWorkbook() : new HSSFWorkbook();
        }
    }

    public void createSheet() throws Exception {
        this.lastSheet = this.hasTemplate ? this.theBook.cloneSheet(0) : this.theBook.createSheet();
    }

    private void initWork(String templateName) throws Exception {
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateName);
        FileOutputStream fileOut = new FileOutputStream(this.handleFileName());
        byte[] bs = new byte[256];
        int n = 0;
        while (n != -1) {
            n = templateStream.read(bs);
            if (n == -1) continue;
            fileOut.write(bs, 0, n);
        }
        fileOut.close();
        templateStream.close();
        templateStream = new FileInputStream(this.filePath);
        this.theBook = templateName.endsWith(XLSX) ? new XSSFWorkbook(templateStream) : new HSSFWorkbook(templateStream);
        this.collectComments();
    }

    private String handleFileName() {
        String fileName = this.filePath.replace("/", File.separator).replace("\\\\", File.separator);
        File destDir = new File(this.filePath.substring(fileName.indexOf(File.separator) + 1, fileName.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return this.filePath.substring(fileName.indexOf(File.separator) + 1, fileName.length());
    }

    private void collectComments() {
        Map comments = this.theBook.getSheetAt(0).getCellComments();
        for (Map.Entry e : comments.entrySet()) {
            CellAddress loc = (CellAddress)e.getKey();
            if (this.firstDataRow < loc.getRow()) {
                this.firstDataRow = loc.getRow();
            }
            if (this.firstDataCol >= loc.getColumn()) continue;
            this.firstDataCol = loc.getColumn();
        }
    }

    public static List<String[]> readExcel(InputStream is, String fileName) throws IOException {
        ExcelUtil.checkFile(is);
        Workbook workbook = ExcelUtil.getWorkBook(is, fileName);
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) continue;
                int firstRowNum = sheet.getFirstRowNum();
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    --firstRowNum;
                }
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
                    Row row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int firstCellNum = row.getFirstCellNum();
                    if (rowNum == 0) {
                        lastCellNum = row.getPhysicalNumberOfCells();
                    }
                    String[] cells = new String[lastCellNum];
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = ExcelUtil.getCellValue(cell);
                    }
                    if (!ExcelUtil.validateCells(cells)) continue;
                    list.add(cells);
                }
            }
            workbook.close();
        }
        return list;
    }

    public static List<String[]> readExcel(InputStream is, String fileName, int RowNumber) throws IOException {
        ExcelUtil.checkFile(is);
        Workbook workbook = ExcelUtil.getWorkBook(is, fileName);
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) continue;
                int firstRowNum = sheet.getFirstRowNum();
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    firstRowNum = firstRowNum + RowNumber - 1;
                }
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
                    Row row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int firstCellNum = row.getFirstCellNum();
                    if (rowNum == RowNumber) {
                        lastCellNum = row.getLastCellNum();
                    }
                    String[] cells = new String[lastCellNum];
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = ExcelUtil.getCellValue(cell);
                    }
                    if (!ExcelUtil.validateCells(cells)) continue;
                    list.add(cells);
                }
            }
            workbook.close();
        }
        return list;
    }

    public static boolean validateCells(String[] cells) {
        for (String str : cells) {
            if (str == null || "".equals(str)) continue;
            return true;
        }
        return false;
    }

    public void writeToSheet(List<List<Object>> rows, String[] header, String[][] footer) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        int cCount = rows.get(0).size() + this.firstDataCol;
        int startRow = 1;
        if (!this.hasTemplate) {
            this.writeHeader(header, rows.get(0).size());
        } else {
            startRow = this.firstDataRow;
        }
        int n = rows.size();
        for (List<Object> row1 : rows) {
            Row row = this.lastSheet.createRow(startRow);
            for (int j = this.firstDataCol; j < cCount; ++j) {
                Object value = row1.get(j - this.firstDataCol);
                Cell cell = row.createCell(j);
                if (value == null) continue;
                if (value instanceof Boolean) {
                    cell.setCellValue((Boolean)value != false ? "\u662f" : "\u5426");
                    continue;
                }
                if (value instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue(value + "");
                    continue;
                }
                cell.setCellValue(value + "");
            }
            ++startRow;
        }
        if (footer == null) {
            return;
        }
        for (int i = 0; i < footer.length; ++i) {
            Row row = this.lastSheet.createRow(startRow);
            for (int j = 0; j < footer[i].length; ++j) {
                String value = footer[i][j];
                Cell cell = row.createCell(j + this.firstDataCol);
                cell.setCellValue(value == null ? "" : value + "");
            }
            ++startRow;
        }
    }

    public void writeToSheet(List<List<Object>> rows, String[] header, String[][] footer, String[][] newHeader) {
        int startRow;
        if (rows == null || rows.size() == 0) {
            return;
        }
        int cCount = rows.get(0).size() + this.firstDataCol;
        boolean hasNewHeader = newHeader != null;
        int n = startRow = hasNewHeader ? newHeader.length + 1 : 1;
        if (!this.hasTemplate) {
            if (hasNewHeader) {
                this.writeHeader(header, rows.get(0).size(), newHeader);
            } else {
                this.writeHeader(header, rows.get(0).size());
            }
        } else {
            startRow = this.firstDataRow;
        }
        int n2 = rows.size();
        for (List<Object> row1 : rows) {
            Row row = this.lastSheet.createRow(startRow);
            for (int j = this.firstDataCol; j < cCount; ++j) {
                Object value = row1.get(j - this.firstDataCol);
                Cell cell = row.createCell(j);
                if (value == null) continue;
                if (value instanceof Boolean) {
                    cell.setCellValue((Boolean)value != false ? "\u662f" : "\u5426");
                    continue;
                }
                if (value instanceof BigDecimal) {
                    cell.setCellValue(((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue(value + "");
                    continue;
                }
                cell.setCellValue(value + "");
            }
            ++startRow;
        }
        if (footer == null) {
            return;
        }
        for (int i = 0; i < footer.length; ++i) {
            Row row = this.lastSheet.createRow(startRow);
            for (int j = 0; j < footer[i].length; ++j) {
                String value = footer[i][j];
                Cell cell = row.createCell(j + this.firstDataCol);
                cell.setCellValue(value == null ? "" : value + "");
                this.lastSheet.setColumnWidth(j, (value + "").getBytes().length * 256);
            }
            ++startRow;
        }
    }

    public void saveBook() throws Exception {
        if (this.hasTemplate) {
            this.theBook.removeSheetAt(0);
            for (int i = 1; i <= this.theBook.getNumberOfSheets(); ++i) {
                this.theBook.setSheetName(i - 1, "\u5de5\u4f5c\u8868" + i);
            }
        }
        String fileName = this.handleFileName();
        this.theBook.write((OutputStream)new FileOutputStream(fileName));
        this.theBook.close();
    }

    private void writeHeader(String[] header, int cCount, String[][] newHeader) {
        int n = newHeader.length;
        for (int i = 0; i < n; ++i) {
            Row row = this.lastSheet.createRow(i);
            for (int j = 0; j < newHeader[i].length; ++j) {
                String value = newHeader[i][j];
                Cell cell = row.createCell(j);
                cell.setCellValue(value == null ? "" : value + "");
                this.lastSheet.setColumnWidth(j, (value + "").getBytes().length * 256);
            }
        }
        Row row = this.lastSheet.createRow(n);
        for (int j = 0; j < cCount; ++j) {
            String value = header[j];
            Cell cell = row.createCell(j);
            if (value == null) continue;
            cell.setCellValue(value + "");
            this.lastSheet.setColumnWidth(j, (value + "").getBytes().length * 256);
        }
    }

    private void writeHeader(String[] header, int cCount) {
        Row row = this.lastSheet.createRow(0);
        for (int j = 0; j < cCount; ++j) {
            String value = header[j];
            Cell cell = row.createCell(j);
            if (value == null) continue;
            cell.setCellValue(value + "");
            this.lastSheet.setColumnWidth(j, (value + "").getBytes().length * 256);
        }
    }

    private static void checkFile(InputStream is) throws IOException {
        if (null == is) {
            logger.error((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    private static Workbook getWorkBook(InputStream is, String fileName) {
        HSSFWorkbook workbook = null;
        try {
            if (fileName.endsWith(XLS)) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(XLSX)) {
                workbook = new XSSFWorkbook(is);
            }
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
        return workbook;
    }

    private static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        if (cell.getCellType() == 0) {
            cell.setCellType(1);
        }
        switch (cell.getCellType()) {
            case 0: {
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            }
            case 4: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 5: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }

    public static Integer getStrType(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (value.matches("\\-?[1-9]\\d+")) {
            return 1;
        }
        if (value.matches("\\-?[1-9]\\d+(\\.\\d+)?")) {
            return 2;
        }
        if (value.matches("\\-?[1-9]\\d+(\\.\\d+)?%")) {
            return 3;
        }
        return 0;
    }

    public static boolean dataToExcel(String[] header, List<List<String>> data, String outSrc) {
        int i;
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        sheet.setColumnWidth(0, 5000);
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = null;
        for (i = 0; i < header.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(header[i]);
        }
        for (i = 0; i < data.size(); ++i) {
            row = sheet.createRow(i + 1);
            List<String> rowData = data.get(i);
            block8: for (int i1 = 0; i1 < rowData.size(); ++i1) {
                cell = row.createCell(i1);
                switch (ExcelUtil.getStrType(rowData.get(i1))) {
                    case 1: {
                        cell.setCellValue((double)Integer.parseInt(rowData.get(i1)));
                        continue block8;
                    }
                    case 2: {
                        cell.setCellValue(Double.parseDouble(rowData.get(i1)));
                        continue block8;
                    }
                    default: {
                        cell.setCellValue(rowData.get(i1));
                    }
                }
            }
        }
        try {
            wk.write((OutputStream)new FileOutputStream(new File(outSrc)));
            wk.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

