package com.aote.util;

import java.io.Reader;
import java.sql.Clob;

/**
 * Clob读取工具
 *
 * @author Mr.river
 */
public class ClobUtil {

    /**
     * 获取clob字符串文本
     *
     * @param c clob对象
     * @return 字符串文本
     */
    public static String getClobString(Clob c) {
        try (Reader reader = c.getCharacterStream()) {
            if (reader == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            char[] charArr = new char[4096];
            for (int i = reader.read(charArr); i > 0; i = reader.read(charArr)) {
                sb.append(charArr, 0, i);
            }
            return sb.toString();
        } catch (Exception e) {
            return "";
        }
    }
}
