package com.aote.sql;

import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

	public static final AliasTransformer INSTANCE = new AliasTransformer();

	/**
	 * Disallow instantiation of AliasToEntityMapResultTransformer.
	 */
	private AliasTransformer() {
	}

	@Override
	public JSONObject transformTuple(Object[] tuple, String[] aliases) {
		JSONObject result = new JSONObject();
		StandardAliasTransformer.runTrans(result, tuple, aliases);
		return result;
	}

	@Override
	public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
		return false;
	}

	/**
	 * Serialization hook for ensuring singleton unique.
	 *
	 * @return The singleton instance : {@link #INSTANCE}
	 */
	private Object readResolve() {
		return INSTANCE;
	}
}
