package com.aote.logic;

import cn.hutool.core.util.NumberUtil;
import com.aote.ThreadResource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * logic映射器
 */
public class LogicMapper {

	static Logger LOGGER = Logger.getLogger(LogicMapper.class);

	private static final long DEFAULT_CACHE_TIME = 60 * 60 * 3;

	private static Map<String, Map<String, String>> map;

	static {
		//初始化即加载
		loadMap();
	}

	public static Map<String, Map<String, String>> getAllMap(){
		return map;
	}

	public static String getLogic(String alias) {
		if (map.containsKey(alias)){
			String result = getLogicByUser(alias);
			if(result != null) {
				return result;
			}
			return map.get(alias).get("path");
		} else {
			return null;
		}
	}

	public static boolean isEnableCache(String alias) {
		if (map.containsKey(alias)){
			String cache = map.get(alias).get("cache");
			return cache != null && cache.equals("true");
		}
		return false;
	}

	public static long getCacheTime(String alias) {
		if (map.containsKey(alias)){
			String time = map.get(alias).get("time");
			// 为了避免缓存雪崩，默认缓存时间为DEFAULT_CACHE_TIME+随机时间
			return time != null ? Long.parseLong(time) :
					DEFAULT_CACHE_TIME + NumberUtil.generateRandomNumber(0, 3601, 1)[0];
		}
		return -1;
	}

	public static Map<String, Map<String, String>> getMap() {
		return LogicMapper.map;
	}

	public  static String getLogicByUser(String alias){
		//获取登陆用户用户名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		//查看对应目录下是否存在相关logic
		String path = "/" + dir + "/logics/" +alias + ".logic";
		if (LogicMapper.class.getResource(path) != null) {
			return path;
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		SAXReader reader = new SAXReader();
		InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = LogicMapper.class.getClassLoader().getResourceAsStream("logic.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator<Element> it = root.elementIterator("logic"); it.hasNext();) {
					Element element = it.next();
					setLogicRes(element, null, null);
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator<Element> it = root.elementIterator("module"); it.hasNext();) {
			Element elm = it.next();
			String name = elm.attribute("name").getValue();
			String path = elm.attributeValue("path");
			putMap(name, reader, path);
		}
	}

	private static void putMap(String name, SAXReader reader, String parent) throws Exception {
		String str = (parent == null ? name + "/logic.xml" : parent + "/" + name + "/logic.xml");
		InputStream moduleLogic = LogicMapper.class.getClassLoader().getResourceAsStream(str);

		if (moduleLogic == null) {
			throw new RuntimeException("注意！！！模块["+ name +"]找不到logic映射文件：" + str);
		}

		Document docLogic = reader.read(moduleLogic);
		Element rootLogic = docLogic.getRootElement();
		for (Iterator<Element> item = rootLogic.elementIterator("logic"); item.hasNext();) {
			Element element = item.next();
			setLogicRes(element, name, parent);
		}
	}

	private static void setLogicRes(Element element, String moduleName, String moduleParent) throws Exception {
		String aliasLogic = element.attribute("alias").getValue();
		String pathLogic = element.attribute("path").getValue();
		String log = element.attributeValue("log");
		String mobile = element.attributeValue("mobile");
		String cache = element.attributeValue("cache");
		String time = element.attributeValue("time");

		// 验证别名是否重复
		if (map.containsKey(aliasLogic)) {
			throw new Exception("Logic别名" + aliasLogic + "已存在");
		}

		String path = (moduleParent == null ? moduleName + "/logics/" : moduleParent + "/" + moduleName + "/logics/") + pathLogic;
		// 设置业务逻辑属性
		Map<String, String> logic = new HashMap<>();
		logic.put("alias", aliasLogic);
		logic.put("path", path);
		logic.put("log", log);
		logic.put("mobile", mobile);
		logic.put("cache", cache);
		logic.put("time", time);
		map.put(aliasLogic, logic);
	}
}
