/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.ThreadResource;
import com.aote.entity.EntityServer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper {
    static Logger LOGGER = Logger.getLogger(SqlMapper.class);
    private static Map<String, Map<String, String>> map;

    public static String getSql(String alias) {
        String result;
        String newAlias;
        switch (EntityServer.findDialect()) {
            case "Oracle": {
                newAlias = alias + "_oracle";
                break;
            }
            case "MySQL": {
                newAlias = alias + "_mysql";
                break;
            }
            default: {
                newAlias = alias;
            }
        }
        if (!map.containsKey(newAlias)) {
            if (map.containsKey(alias)) {
                newAlias = alias;
            } else {
                return null;
            }
        }
        if ((result = SqlMapper.getSqlByUser(newAlias)) != null) {
            return result;
        }
        return map.get(newAlias).get("path");
    }

    public static Map<String, Map<String, String>> getMap() {
        return map;
    }

    public static String getSqlByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = "/" + dir + "/sqls/" + alias + ".sql";
        if (SqlMapper.class.getResource(path) != null) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                SqlMapper.parseModule(module);
            }
            if ((input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator item = root.elementIterator("sql");
                while (item.hasNext()) {
                    Element element = (Element)item.next();
                    SqlMapper.setSqlRes(element, null, null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String path = elm.attributeValue("path");
            SqlMapper.putMap(name, reader, path);
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        String str = parent == null ? name + "/sql.xml" : parent + "/" + name + "/sql.xml";
        InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(str);
        if (moduleSql != null) {
            Document docSql = reader.read(moduleSql);
            Element rootSql = docSql.getRootElement();
            Iterator item = rootSql.elementIterator("sql");
            while (item.hasNext()) {
                Element element = (Element)item.next();
                SqlMapper.setSqlRes(element, name, parent);
            }
        }
    }

    private static void setSqlRes(Element element, String moduleName, String moduleParent) throws Exception {
        String aliasSql = element.attribute("alias").getValue();
        String pathSql = element.attribute("path").getValue();
        String mobile = element.attributeValue("mobile");
        if (map.containsKey(aliasSql)) {
            throw new Exception("Sql\u522b\u540d" + aliasSql + "\u5df2\u5b58\u5728");
        }
        String path = moduleName == null ? "sqls/" + pathSql : (moduleParent == null ? moduleName + "/sqls/" : moduleParent + "/" + moduleName + "/sqls/") + pathSql;
        HashMap<String, String> sql = new HashMap<String, String>();
        sql.put("alias", aliasSql);
        sql.put("path", path);
        sql.put("mobile", mobile);
        map.put(aliasSql, sql);
    }

    static {
        SqlMapper.loadMap();
    }
}

