/*
 * Decompiled with CFR 0.152.
 */
package com.aote.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.DateUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Locale;

public class TimestampStringConverter
implements Converter<Timestamp> {
    public Class<?> supportJavaTypeKey() {
        return Timestamp.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Timestamp convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return Timestamp.valueOf(cellData.getStringValue());
    }

    public WriteCellData<?> convertToExcelData(Timestamp value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        WriteCellData cellData = new WriteCellData();
        String cellValue = contentProperty == null || contentProperty.getDateTimeFormatProperty() == null ? DateUtils.format((LocalDateTime)value.toLocalDateTime(), null, (Locale)globalConfiguration.getLocale()) : DateUtils.format((LocalDateTime)value.toLocalDateTime(), (String)contentProperty.getDateTimeFormatProperty().getFormat(), (Locale)globalConfiguration.getLocale());
        cellData.setType(CellDataTypeEnum.STRING);
        cellData.setStringValue(cellValue);
        cellData.setData((Object)cellValue);
        return cellData;
    }
}

