/*
 * Decompiled with CFR 0.152.
 */
package com.aote.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class BaseDateConverter {

    public static class LocalDateTimeConverter
    extends CoreConverter<LocalDateTime> {
        public LocalDateTimeConverter() {
            super(LocalDateTime.class);
        }
    }

    public static class LocalTimeConverter
    extends CoreConverter<LocalTime> {
        public LocalTimeConverter() {
            super(LocalTime.class);
        }
    }

    public static class LocalDateConverter
    extends CoreConverter<LocalDate> {
        public LocalDateConverter() {
            super(LocalDate.class);
        }
    }

    private static abstract class CoreConverter<T>
    implements Converter<T> {
        private final Class<T> clazz;

        public CoreConverter(Class<T> clazz) {
            this.clazz = clazz;
        }

        public CellDataTypeEnum supportExcelTypeKey() {
            return CellDataTypeEnum.STRING;
        }

        public Class<?> supportJavaTypeKey() {
            return this.clazz;
        }

        public T convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty property, GlobalConfiguration config) {
            if (cellData.getData() instanceof LocalDate) {
                return (T)LocalDate.parse(cellData.getStringValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            if (cellData.getData() instanceof LocalTime) {
                return (T)LocalTime.parse(cellData.getStringValue(), DateTimeFormatter.ofPattern("HH:mm:ss"));
            }
            if (cellData.getData() instanceof LocalDateTime) {
                return (T)LocalDateTime.parse(cellData.getStringValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            return null;
        }

        public WriteCellData<?> convertToExcelData(T obj, ExcelContentProperty property, GlobalConfiguration config) {
            if (obj instanceof LocalDate) {
                return new WriteCellData(((LocalDate)obj).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            }
            if (obj instanceof LocalTime) {
                return new WriteCellData(((LocalTime)obj).format(DateTimeFormatter.ofPattern("HH:mm:ss")));
            }
            if (obj instanceof LocalDateTime) {
                return new WriteCellData(((LocalDateTime)obj).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            return new WriteCellData(obj.toString());
        }
    }
}

