/*
 * Decompiled with CFR 0.152.
 */
package com.aote.config;

import com.aote.config.SaleVersionEnum;
import com.aote.exception.FileNotFoundException;
import com.aote.util.other.JsonTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SystemConfig {
    private static final Logger LOGGER = Logger.getLogger(SystemConfig.class);
    private static final String CONFIG_PATH = "systemConfig.json";
    private static boolean isLoaded = false;

    private static void load() {
        if (!isLoaded) {
            isLoaded = true;
            if (SystemConfig.class.getClassLoader().getResource(CONFIG_PATH) != null) {
                SaleVersionEnum saleVersionEnum;
                JSONObject params = JsonTools.readJsonFile(CONFIG_PATH);
                JSONObject system = params.getJSONObject("system");
                if (!system.has("webAppName")) {
                    throw new RuntimeException("systemConfig.json\u4e2d\u670d\u52a1\u5e94\u7528\u6a21\u5757\u540d\u53c2\u6570[system:webAppName]\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\u8be5\u53c2\u6570\u4e3aweb\u5e94\u7528\u540d\u79f0\uff0c\u5982revenue,webmeter\u7b49");
                }
                System.webAppName = system.getString("webAppName");
                if (!system.has("saleVersion")) {
                    LOGGER.warn((Object)"systemConfig.json\u4e2d\u670d\u52a1\u5e94\u7528\u6a21\u5757\u540d\u53c2\u6570[system:saleVersion]\u4e0d\u5b58\u5728\uff0c\u9ed8\u8ba4\u4e3aVue-V3.");
                    saleVersionEnum = SaleVersionEnum.Vue_V3;
                } else {
                    saleVersionEnum = SaleVersionEnum.toType(system.getString("saleVersion"));
                    if (saleVersionEnum == null) {
                        throw new RuntimeException("systemConfig.json\u4e2d\u670d\u52a1\u5e94\u7528\u6a21\u5757\u540d\u53c2\u6570[system:saleVersion]\u914d\u7f6e\u6709\u8bef\uff0c\u4e0d\u5b58\u5728\u7684\u503c\uff1a" + system.getString("saleVersion"));
                    }
                }
                System.saleVersion = saleVersionEnum;
                JSONObject persistenceLog = params.getJSONObject("persistenceLog");
                PersistenceLog.isEnabled = persistenceLog.optBoolean("isEnabled", false);
                if (PersistenceLog.isEnabled.booleanValue()) {
                    LOGGER.info((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5f00\u542f\uff0c\u5982\u9700\u5173\u95ed\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3afalse.");
                } else {
                    LOGGER.warn((Object)"\u5f02\u5e38\u65e5\u5fd7\u6301\u4e45\u5316\u8bb0\u5f55\u5df2\u5173\u95ed\uff0c\u5982\u9700\u5f00\u542f\uff0c\u8bf7\u5c06systemConfig.json\u4e2d[persistenceLog:isEnabled]\u914d\u7f6e\u4e3atrue.");
                }
                JSONObject redis = params.getJSONObject("redis");
                Redis.hostName = redis.optString("hostName", null);
                Redis.password = redis.optString("password", null);
                JSONObject resources = params.getJSONObject("resources");
                if (!resources.has("fileRootPath")) {
                    LOGGER.warn((Object)("systemConfig.json\u4e2d\u8d44\u6e90\u6839\u76ee\u5f55\u53c2\u6570[resources:fileRootPath]\u4e0d\u5b58\u5728\uff0c\u4ee5\u6309\u7167\u7f3a\u7701\u503c[D:/" + System.webAppName + "Res]\u914d\u7f6e"));
                }
                Resources.fileRootPath = resources.optString("fileRootPath", "D:/" + System.webAppName + "Res");
                if (resources.has("extraPaths")) {
                    Resources.extraPaths = resources.getJSONObject("extraPaths");
                }
                SubClass.subClassArray = params.optJSONArray("subclass");
                Dataflow.isEnabled = params.optBoolean("isEnabled", false);
                Dataflow.partitionTables = params.optJSONArray("partitionTables");
            } else {
                throw new FileNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6systemConfig.json\u4e0d\u5b58\u5728", CONFIG_PATH);
            }
        }
    }

    public static class Dataflow {
        private static Boolean isEnabled;
        private static JSONArray partitionTables;

        public static Boolean getEnabled() {
            return isEnabled;
        }

        public static JSONArray getPartitionTables() {
            return partitionTables;
        }

        public static boolean hasPartitionTables() {
            return partitionTables != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class SubClass {
        private static JSONArray subClassArray;

        public static JSONArray getSubClassArray() {
            return subClassArray;
        }

        public static boolean hasSubClassArray() {
            return subClassArray != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Resources {
        private static String fileRootPath;
        private static JSONObject extraPaths;

        public static String getFileRootPath() {
            return fileRootPath;
        }

        public static String getExtraPath(String key) {
            return extraPaths.getString(key);
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Redis {
        private static String hostName;
        private static String password;

        public static String getHostName() {
            return hostName;
        }

        public static boolean hasHostName() {
            return hostName != null;
        }

        public static String getPassword() {
            return password;
        }

        public static boolean hasPassword() {
            return password != null;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class PersistenceLog {
        private static Boolean isEnabled;

        public static Boolean getEnabled() {
            return isEnabled;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class System {
        private static String webAppName;
        private static SaleVersionEnum saleVersion;

        public static String getWebAppName() {
            return webAppName;
        }

        public static SaleVersionEnum saleVersion() {
            return saleVersion;
        }

        static {
            SystemConfig.load();
        }
    }
}

