/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.af.plugins.RedisTools;
import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.path.PathMapper;
import com.aote.path.PathServer;
import com.aote.redis.RedisUtil;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.transaction.ThreadSession;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component
@Transactional
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    public SessionPool sessionPool;
    @Autowired
    public SessionFactory sessionFactory;
    @Autowired
    private ThreadPoolTaskExecutor executorService;
    @Autowired
    private ThreadSession tSession;
    private static ExecutorService logicExecutor = Executors.newCachedThreadPool();
    private JSONObject context = null;

    public Object run(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("context")) {
                    this.context = param.getJSONObject("context");
                }
                if (!param.isNull("data")) {
                    Object dataParam = param.get("data");
                    param = dataParam instanceof String ? new JSONObject(param.getString("data")) : param.getJSONObject("data");
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param, JSONObject context) {
        String path = LogicMapper.getLogic(name);
        if (path == null) {
            throw new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        String source = null;
        try {
            source = ResourceHelper.getString(path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        if (context != null) {
            params.put("context", context);
        }
        params.put("log", this);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("path", this.pathServer);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", this.redisUtil);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        for (String key : plugins.keySet()) {
            params.put(key, plugins.get(key));
        }
        return ExpressionHelper.run(source, params);
    }

    public Object run(String name, JSONObject param) throws Exception {
        return this.run(name, param, this.context);
    }

    public Object runAsync(final String name, final JSONObject param) throws Exception {
        final Semaphore semaphore = new Semaphore(this.executorService.getCorePoolSize());
        Future futureTask = this.executorService.submit((Callable)new Callable<Object>(){
            Session session;
            {
                this.session = LogicServer.this.sessionFactory.openSession();
            }

            @Override
            public Object call() throws Exception {
                TransactionSynchronizationManager.bindResource((Object)LogicServer.this.sessionFactory, (Object)this.session);
                log.info((Object)"\u5f00\u59cb\u8bf7\u6c42\u7b2c\u4e09\u65b9\u63a5\u53e3\uff08\u7ebf\u7a0b\u6c60\u5904\u7406\uff09");
                semaphore.acquire();
                Object result = LogicServer.this.run(name, param);
                semaphore.release();
                log.info((Object)"\u5df2\u5904\u7406\u5b8c\u6210\uff08\u7ebf\u7a0b\u6c60\u5904\u7406\uff09");
                TransactionSynchronizationManager.unbindResourceIfPossible((Object)LogicServer.this.sessionFactory);
                if (this.session != null) {
                    this.session.close();
                }
                return result;
            }
        });
        return futureTask.get();
    }

    public void simpleRunAsync(String name, String params) {
        new Thread(() -> {
            try {
                this.run(name, params);
            }
            catch (Exception e) {
                log.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                e.printStackTrace();
            }
        }).start();
    }

    public void simpleRunAsync(String name, JSONObject params) {
        this.simpleRunAsync(name, params.toString());
    }

    public Object noTranscRun(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("data")) {
                    param = param.getJSONObject("data");
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.noTranscRun(name, param);
    }

    public Object noTranscRun(String name, JSONObject param) throws Exception {
        String path = LogicMapper.getLogic(name);
        String source = ResourceHelper.getString("/logics/" + path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        SqlServer sqlServer = new SqlServer();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            sqlServer.setAssignedSession(session);
            params.put("sql", sqlServer);
            params.put("session", session);
            params.put("logic", this);
            Map<String, Object> plugins = PluginMapper.getPlugins();
            for (String key : plugins.keySet()) {
                params.put(key, plugins.get(key));
            }
            Object object = ExpressionHelper.run(source, params);
            return object;
        }
    }

    public void fatal(Object msg) {
        log.fatal(msg);
    }

    public void error(Object msg) {
        log.error(msg);
    }

    public void warn(Object msg) {
        log.warn(msg);
    }

    public void debug(Object msg) {
        log.debug(msg);
    }

    public void info(Object msg) {
        log.info(msg);
    }

    public void trace(Object msg) {
        log.trace(msg);
    }

    public void debug(String logic, Object msg) {
        String level = LogicMapper.getAttr(logic, "log");
        if (level != null) {
            log.debug((Object)(logic + ":" + msg));
        }
    }

    public void redisCacheLogic() throws Exception {
        block41: {
            if (ResourceHelper.class.getResourceAsStream("/config.json") == null) {
                log.warn((Object)"\u65e0config.json\u6587\u4ef6\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
                return;
            }
            String strConfig = ResourceHelper.getString("config.json");
            JSONObject jsonObject = new JSONObject(strConfig);
            if (!jsonObject.has("logicRegister")) {
                log.warn((Object)"\u65e0\u6a21\u5757\u955c\u50cf\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
                return;
            }
            JSONObject logicJsonObject = jsonObject.getJSONObject("logicRegister");
            String url = logicJsonObject.getString("url");
            if (url == null) {
                log.warn((Object)"\u65e0url\uff0c\u4e0d\u8fdb\u884credis\u7f13\u5b58");
                return;
            }
            try {
                if (logicJsonObject.get("redis") instanceof JSONObject) {
                    JSONObject redisObject = logicJsonObject.getJSONObject("redis");
                    String redisHost = redisObject.getString("host");
                    int redisPort = redisObject.getInt("port");
                    String redispwd = "";
                    try {
                        redispwd = redisObject.getString("redispwd");
                    }
                    catch (JSONException e) {
                        log.info((Object)"\u65e0redis\u5bc6\u7801");
                    }
                    RedisTools.getJedisPool((String)redisHost, (int)redisPort);
                    Map<String, Map<String, String>> map = LogicMapper.getMap();
                    if (map != null) {
                        for (String string : map.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)string, (String)url);
                            } else {
                                RedisTools.setValue((String)string, (String)url, (String)redispwd);
                            }
                            log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + string + ", value=" + url));
                        }
                    }
                    if ((map = SqlMapper.getMap()) != null) {
                        for (String string : map.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)string, (String)url);
                            } else {
                                RedisTools.setValue((String)string, (String)url, (String)redispwd);
                            }
                            log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + string + ", value=" + url));
                        }
                    }
                    if ((map = PathMapper.getMap()) != null) {
                        for (String string : map.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)string, (String)url);
                            } else {
                                RedisTools.setValue((String)string, (String)url, (String)redispwd);
                            }
                            log.info((Object)("path\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + string + ", value=" + url));
                        }
                    }
                    Map entities = this.sessionFactory.getAllClassMetadata();
                    for (String key : entities.keySet()) {
                        if ("".equals(redispwd)) {
                            RedisTools.setValue((String)key, (String)url);
                        } else {
                            RedisTools.setValue((String)key, (String)url, (String)redispwd);
                        }
                        log.info((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                    }
                    break block41;
                }
                log.info((Object)"\u6ce8\u518c\u591a\u4e2aRedis\u5730\u5740-----");
                JSONArray redisarry = logicJsonObject.getJSONArray("redis");
                for (int i = 0; i < redisarry.length(); ++i) {
                    Map<String, Map<String, String>> map;
                    Map<String, Map<String, String>> map2;
                    log.info((Object)("\u3010\u5f00\u59cb\u3011\u6ce8\u518c\u4e00\u4e2aRedis\u5730\u5740" + redisarry.getJSONObject(i)));
                    JSONObject redisObject = redisarry.getJSONObject(i);
                    String redisHost = redisObject.getString("host");
                    int redisPort = redisObject.getInt("port");
                    String redispwd = "";
                    try {
                        redispwd = redisObject.getString("redispwd");
                    }
                    catch (JSONException jSONException) {
                        log.info((Object)"\u65e0redis\u5bc6\u7801");
                    }
                    RedisTools.getJedisPool((String)redisHost, (int)redisPort);
                    Map<String, Map<String, String>> map3 = LogicMapper.getMap();
                    if (map3 != null) {
                        for (String key : map3.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)key, (String)url);
                            } else {
                                RedisTools.setValue((String)key, (String)url, (String)redispwd);
                            }
                            log.info((Object)("logic\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                        }
                    }
                    if ((map2 = SqlMapper.getMap()) != null) {
                        for (String key : map2.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)key, (String)url);
                            } else {
                                RedisTools.setValue((String)key, (String)url, (String)redispwd);
                            }
                            log.info((Object)("sql\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                        }
                    }
                    if ((map = PathMapper.getMap()) != null) {
                        for (String key : map.keySet()) {
                            if ("".equals(redispwd)) {
                                RedisTools.setValue((String)key, (String)url);
                            } else {
                                RedisTools.setValue((String)key, (String)url, (String)redispwd);
                            }
                            log.info((Object)("path\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                        }
                    }
                    Map entities = this.sessionFactory.getAllClassMetadata();
                    for (String key : entities.keySet()) {
                        if ("".equals(redispwd)) {
                            RedisTools.setValue((String)key, (String)url);
                        } else {
                            RedisTools.setValue((String)key, (String)url, (String)redispwd);
                        }
                        log.info((Object)("entity\u52a0\u5165redis\u7f13\u5b58\uff0ckey=" + key + ", value=" + url));
                    }
                    log.info((Object)("\u3010\u7ed3\u675f\u3011\u6ce8\u518c\u4e00\u4e2aRedis\u5730\u5740" + redisarry.getJSONObject(i)));
                }
            }
            catch (JedisConnectionException e) {
                log.warn((Object)"\u65e0\u6cd5\u8fde\u63a5redis\u670d\u52a1\u5668\uff0c\u672a\u6210\u529f\u6ce8\u518c\u4e1a\u52a1\u903b\u8f91\u7b49\u7ec4\u4ef6\uff01");
            }
        }
    }
}

