package com.aote.queryparams;

import java.util.stream.Stream;

/**
 * 表单类型
 * @author Mr.river
 */
public enum FormTypeEnum {
    //输入框
    INPUT("input"),
    //选择框
    SELECT("select"),
    //级联多个选择框
    SELECTS("selects"),
    //日期范围选择框
    RANGE_PICKER("rangePicker"),
    //月份选择框
    MONTH_PICKER("monthPicker"),
    //星期选择框
    WEEK_PICKER("weekPicker"),
    //级联选择框
    CASCADER("cascader"),
    //文本域
    TEXTAREA("textarea");

    private final String value;

    FormTypeEnum(String value) {
        this.value = value;
    }

    public static FormTypeEnum toType(String value) {
        return Stream.of(FormTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
