package com.aote.queryparams;

import java.util.stream.Stream;

/**
 * 静默场景字段用途枚举
 * @author Mr.river
 */
public enum SilencePurposeEnum {
    //创建时间
    CREATE_TIME("createTime"),
    //创建人/操作人
    OPERATOR("operator"),
    //组织机构ID
    ORG_ID("orgId"),
    //自定义
    CUSTOMIZE("customize");
    private final String value;

    SilencePurposeEnum(String value) {
        this.value = value;
    }

    public static SilencePurposeEnum toType(String value) {
        return Stream.of(SilencePurposeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
