/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ParamFilter {
    static Logger log = Logger.getLogger(ParamFilter.class);
    private static Map<String, Object> sqlkeywords = new HashMap<String, Object>();

    public static void checkSqlMap(Map<String, Object> map) {
        for (Object m : map.values()) {
            ParamFilter.checkSqlStr(String.valueOf(m));
        }
    }

    public static void checkSqlJsonStr(String jsonStr) {
        log.debug((Object)("\u5f85\u68c0\u6570\u636e\uff1a" + jsonStr));
        JSONObject jsonObject = new JSONObject(jsonStr);
        ParamFilter.checkSqlJson(jsonObject);
    }

    public static void checkSqlJson(JSONObject jsonObject) {
        for (String k : jsonObject.keySet()) {
            Object v = jsonObject.get(k);
            ParamFilter.checkSqlJsonV(v);
        }
    }

    public static void checkSqlJsonV(Object v) {
        if (v instanceof JSONArray) {
            JSONArray ja = new JSONArray(String.valueOf(v));
            for (int i = 0; i < ja.length(); ++i) {
                Object value = ja.get(i);
                ParamFilter.checkSqlJsonV(value);
            }
        } else if (v instanceof JSONObject) {
            ParamFilter.checkSqlJson((JSONObject)v);
        } else if (v instanceof String) {
            String vStr = String.valueOf(v);
            if (vStr.startsWith("{")) {
                ParamFilter.checkSqlJsonV(new JSONObject(vStr));
            } else if (vStr.startsWith("[")) {
                ParamFilter.checkSqlJsonV(new JSONArray(vStr));
            } else {
                ParamFilter.checkSqlStr(vStr);
            }
        }
    }

    public static void checkSqlStr(String str) {
        String[] strs;
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        str = str.toLowerCase();
        for (String trimStr : strs = str.split(" ")) {
            if (!sqlkeywords.containsKey(trimStr)) continue;
            log.error((Object)("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + trimStr));
            throw new RuntimeException("\u53c2\u6570\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + trimStr);
        }
    }

    static {
        sqlkeywords.put("select", "select");
        sqlkeywords.put("insert", "insert");
        sqlkeywords.put("update", "update");
        sqlkeywords.put("delete", "delete");
        sqlkeywords.put("from", "from");
        sqlkeywords.put("drop", "drop");
        sqlkeywords.put("count", "count");
        sqlkeywords.put("table", "table");
        sqlkeywords.put("truncate", "truncate");
        sqlkeywords.put("declare", "declare");
        sqlkeywords.put("asc(", "asc(");
        sqlkeywords.put("mid(", "mid(");
        sqlkeywords.put("char(", "char(");
        sqlkeywords.put("where", "where");
        sqlkeywords.put("master", "master");
        sqlkeywords.put("netlocalgroup", "netlocalgroup");
        sqlkeywords.put("administrators", "administrators");
        sqlkeywords.put("xp_cmdshell", "xp_cmdshell");
        sqlkeywords.put("exec", "exec");
        sqlkeywords.put("execute", "execute");
        sqlkeywords.put("xp_", "xp_");
        sqlkeywords.put("sp_", "sp_");
        sqlkeywords.put("0x", "0x");
        sqlkeywords.put(";", ";");
        sqlkeywords.put("or", "or");
        sqlkeywords.put("\"t_user\"", "\"t_user\"");
        sqlkeywords.put("--", "--");
        sqlkeywords.put("#", "#");
        sqlkeywords.put("union", "union");
        sqlkeywords.put("/", "/");
        sqlkeywords.put("//", "//");
    }
}

