/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.mq.RocketMQProducer;
import com.aote.util.ResourceHelper;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    private final LogicServer logicServer;
    private final RocketMQProducer producer;
    private final ResourceHelper resourceHelper;

    public LogicService(LogicServer logicServer, RocketMQProducer producer, ResourceHelper resourceHelper) {
        this.logicServer = logicServer;
        this.producer = producer;
        this.resourceHelper = resourceHelper;
    }

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Path(value="/clearall")
    public String clearAllCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        ResourceHelper.clearPathCache();
        this.resourceHelper.clearQueryParamsCache();
        return "ok";
    }

    @GET
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return this.runMain(logicName, values);
    }

    @POST
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        values = this.getValues(values, request);
        return this.runMain(logicName, values);
    }

    @GET
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        String values = params.toString();
        return this.runMQ(logicName, values);
    }

    @POST
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        values = this.getValues(values, request);
        return this.runMQ(logicName, values);
    }

    @GET
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        try {
            this.runAsync(logicName, params.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params.has("msg")) {
            return Response.ok((Object)params.getJSONArray("msg").get(0)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        try {
            this.runAsync(logicName, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Response.ok().build();
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    public String xtSave(String logicName, String values) {
        return this.xtSave(logicName, values, null).getEntity().toString();
    }

    private Response runMain(String logicName, String values) {
        JSONObject paramJson;
        String result = this.logicServer.runMain(logicName, values);
        Response.ResponseBuilder builder = Response.ok();
        if (result.startsWith("{") && (paramJson = new JSONObject(result)).has("header") && paramJson.has("content")) {
            Map paramHeader = paramJson.getJSONObject("header").toMap();
            for (Map.Entry stringObjectEntry : paramHeader.entrySet()) {
                builder.header((String)stringObjectEntry.getKey(), (Object)String.valueOf(stringObjectEntry.getValue()));
            }
            return builder.type("text/plain").entity((Object)String.valueOf(paramJson.get("content"))).build();
        }
        return builder.entity((Object)result).build();
    }

    private Response runMQ(String logicName, String values) throws RemotingException, InterruptedException, MQClientException {
        Message msg = new Message("logic", logicName, values.getBytes(StandardCharsets.UTF_8));
        this.producer.getDefaultMQProducer().sendOneway(msg);
        return Response.ok().build();
    }

    private void runAsync(String logicName, String values) {
        this.logicServer.runAsync(logicName, values);
    }
}

