package com.aote.util;

import com.aote.sql.AliasTransformer;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.orm.hibernate3.HibernateCallback;

import java.util.List;
import java.util.Map;

public class SqlHelper {
	static Logger log = Logger.getLogger(SqlHelper.class);

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql) {
		JSONArray array = new JSONArray();
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, 0, 9999999);
		sqlCall.transformer = AliasTransformer.INSTANCE;

		long begin = System.currentTimeMillis();
		try {
			List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
					.doInHibernate(session);
			for (Map<String, Object> map : list) {
				JSONObject json = JsonTransfer.MapToJson(map);
				array.put(json);
			}
			return array;
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
		}
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql, int pageNo,
								  int pageSize, boolean isNoLog) throws Exception {
		JSONArray array = new JSONArray();
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
		sqlCall.transformer = AliasTransformer.INSTANCE;

		long begin = System.currentTimeMillis();
		try {
			List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
					.doInHibernate(session);
			for (Map<String, Object> map : list) {
				JSONObject json = JsonTransfer.MapToJson(map);
				array.put(json);
			}
			return array;
		} finally {
			long end = System.currentTimeMillis();
			if(!isNoLog) {
				log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
			}
		}
	}

	public static JSONArray query(Session session, String sql, int pageNo,
								  int pageSize) throws Exception {
		return query(session, sql, pageNo, pageSize,false);
	}

	/**
	 * hql基本查询
	 * @param session
	 * @param sql
	 * @return JSONArray
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session,String sql) throws Exception
	{
		JSONArray array=new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, 0, 9999999);

		long begin = System.currentTimeMillis();
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		long end = System.currentTimeMillis();
		log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
		for (Map<String, Object> map : list) {
			JSONObject json = JsonTransfer.MapToJson(map);
			array.put(json);
		}
		return array;
	}
	/**
	 * hql分页查询
	 * @param session
	 * @param sql
	 * @param pageNo
	 * @param pageSize
	 * @return  JSONArray
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session, String sql, int pageNo,
									 int pageSize) throws Exception {
		JSONArray array = new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, pageNo, pageSize);

		long begin = System.currentTimeMillis();
		try {
			List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
					.doInHibernate(session);
			for (Map<String, Object> map : list) {
				JSONObject json = JsonTransfer.MapToJson(map);
				array.put(json);
			}
			return array;
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sqlCall.sql + "\n}");
		}
	}

	public static int bulkSQLUpdate(Session session, String sql) {
		Query queryObject = session.createSQLQuery(sql);
		long begin = System.currentTimeMillis();
		try {
			return queryObject.executeUpdate();
		} finally {
			long end = System.currentTimeMillis();
			log.debug("维护信息:执行SQL耗时：" + (end - begin) + "ms:{\n" + sql + "\n}");
		}
	}

	@SuppressWarnings("rawtypes")
	public static class HibernateSQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		public ResultTransformer transformer = null;

		public HibernateSQLCall(String sql, int page, int rows) {
			this.sql = sql;
			this.page = page;
			this.rows = rows;
		}

		@Override
		public Object doInHibernate(Session session) {
			Query q = session.createSQLQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				return q.setFirstResult(page * rows).setMaxResults(rows).list();
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}
	@SuppressWarnings("rawtypes")
	static class HibernateHQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		ResultTransformer transformer = null;

		public HibernateHQLCall(String sql, int page, int rows) {
			this.sql = sql;
			this.page = page;
			this.rows = rows;
		}

		@Override
		public Object doInHibernate(Session session) {
			Query q = session.createQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				return q.setFirstResult(page * rows).setMaxResults(rows).list();
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}

}
