package com.aote.transaction;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 线程内使用session的支持
 */
@Component
public class ThreadSession {
    static Logger log = Logger.getLogger(ThreadSession.class);

    @Autowired
    private SessionFactory factory;

    private ThreadLocal<Session> threadLocal = new ThreadLocal<>();

    public void commit() {
        Session session = threadLocal.get();
        if (session != null) {
            try {
                session.flush();
                session.getTransaction().commit();
            } finally {
                threadLocal.set(null);
                session.close();
            }
        }
    }

    public void rollback(){
        Session session = threadLocal.get();
        if (session != null) {
            try {
                session.getTransaction().rollback();
            } finally {
                threadLocal.set(null);
                session.close();
            }
        }
    }

    public void create(){
        Session session = this.factory.openSession();
        session.beginTransaction();
        threadLocal.set(session);
    }

    public Session get(){
        return threadLocal.get();
    }
}
