package com.aote.queryparams;

import java.util.stream.Stream;

/**
 * 数据模式类型
 *
 * 各类型用法请参考docs/DataModeEnum.md
 *
 * @author Mr.river
 */
public enum DataModeEnum {
    ALL("all"),
    FORM("form"),
    TABLE("table"),
    TABLE_FORM("table_form"),
    ONLY_FORM("only_form"),
    ONLY_TABLE("only_table"),
    ONLY_QUERY("only_query"),
    ONLY_CONDITION("only_condition");

    private final String value;

    DataModeEnum(String value) {
        this.value = value;
    }

    public static DataModeEnum toType(String value) {
        return Stream.of(DataModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
