package com.aote.queryparams.enums;

import com.aote.config.SaleVersionEnum;
import com.aote.config.SystemConfig;

import java.util.stream.Stream;

/**
 * 兼容性字段名
 *
 * @author Mr.river
 */
public enum CompatColumnNameEnum {
    USER_ID("$userid", "f_user_id", "f_userfiles_id");

    private final String name;

    private final String v2Value;

    private final String v3Value;

    CompatColumnNameEnum(String name, String v2Value, String v3Value) {
        this.name = name;
        this.v2Value = v2Value;
        this.v3Value = v3Value;
    }

    public static CompatColumnNameEnum toType(String name) {
        return Stream.of(CompatColumnNameEnum.values())
                .filter(p -> p.name.equals(name))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getName(){
        return name;
    }

    public String getValue() {
        if(SystemConfig.System.saleVersion() == SaleVersionEnum.Vue_V3){
            return this.v3Value;
        } else {
            return this.v2Value;
        }
    }
}
