package com.aote.util;

import java.util.stream.Stream;

public enum ResourceType {
    /**
     * LOGIC文件
     */
    LOGIC("logic"),
    /**
     * SQL文件
     */
    SQL("sql"),
    /**
     * PATH文件
     */
    PATH("path");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    public static ResourceType toType(String value) {
        return Stream.of(ResourceType.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
