package com.aote.util;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * sql关键字过滤(防sql注入)
 */
public class ParamFilter {
    static Logger log = Logger.getLogger(ParamFilter.class);

    //sql非法字符
    private static  Map<String,Object> sqlkeywords = new HashMap<>();

    static{
        sqlkeywords.put("select","select");
        sqlkeywords.put("insert","insert");
        sqlkeywords.put("update","update");
        sqlkeywords.put("delete","delete");
        sqlkeywords.put("from","from");
        sqlkeywords.put("drop","drop");
        sqlkeywords.put("count","count");
        sqlkeywords.put("table","table");
        sqlkeywords.put("truncate","truncate");
        sqlkeywords.put("declare","declare");
        sqlkeywords.put("asc(","asc(");
        sqlkeywords.put("mid(","mid(");
        sqlkeywords.put("char(","char(");
        sqlkeywords.put("where","where");
        sqlkeywords.put("master","master");
        sqlkeywords.put("netlocalgroup","netlocalgroup");
        sqlkeywords.put("administrators","administrators");
        sqlkeywords.put("xp_cmdshell","xp_cmdshell");

        sqlkeywords.put("exec","exec");
        sqlkeywords.put("execute","execute");
        sqlkeywords.put("xp_","xp_");
        sqlkeywords.put("sp_","sp_");
        sqlkeywords.put("0x","0x");
        sqlkeywords.put(";",";");
        sqlkeywords.put("or","or");
        sqlkeywords.put("\"t_user\"","\"t_user\"");
        sqlkeywords.put("--","--");
        sqlkeywords.put("#","#");
        sqlkeywords.put("union","union");
        sqlkeywords.put("/","/");
        sqlkeywords.put("//","//");
//            "select","insert","update","delete","from","drop","count","table","truncate","declare","asc(","mid(","char(",
//            "where","master","netlocalgroup","administrators","xp_cmdshell","net user","exec","execute","xp_","sp_","0x",
//            ";","or","\"t_user\"","--","#","union","/","//"
    };

    /**
     * SQL注入检测
     * @param map 待检测map,只检查value
     */
    public static void checkSqlMap(Map<String, Object> map){
        for(Object m : map.values()){
            checkSqlStr(String.valueOf(m));
        }
    }
    /**
     * SQL注入检测
     * @param jsonStr 待检测json,只检查value
     */
    public static void checkSqlJsonStr(String jsonStr) {
        log.debug("待检数据："+jsonStr);
        JSONObject jsonObject = new JSONObject(jsonStr);
        checkSqlJson(jsonObject);
    }
    /**
     * SQL注入检测
     * @param jsonObject 待检测json,只检查value
     */
    public static void checkSqlJson (JSONObject jsonObject) {
        for (String k : jsonObject.keySet()) {
            Object v = jsonObject.get(k);
            checkSqlJsonV(v);
        }
    }

    public static void checkSqlJsonV(Object v){
        if (v instanceof JSONArray) {
            JSONArray ja = new JSONArray(String.valueOf(v));
            for(int i=0;i<ja.length();i++ ){
                Object value = ja.get(i);
                checkSqlJsonV(value);
            }
        } else if (v instanceof JSONObject) {
            checkSqlJson((JSONObject) v);
        } else if( v instanceof String){
            String vStr = String.valueOf(v);
            if(vStr.startsWith("{")){
                checkSqlJsonV(new JSONObject(vStr));
            } else if(vStr.startsWith("[")){
                checkSqlJsonV(new JSONArray(vStr));
            } else {
                checkSqlStr(vStr);
            }
        }
    }

    /**
     * SQL注入检测
     * @param str  待验证的字符串
     */
    public static void checkSqlStr(String str){
        if(StringUtils.isBlank(str)){
            return;
        }
        //转换成小写
        str = str.toLowerCase();
        //判断是否包含非法字符
        String [] strs = str.split(" ");
        for(String trimStr: strs){
            if(sqlkeywords.containsKey(trimStr)){
                log.debug("参数包含非法字符:"+trimStr);
                throw new RuntimeException("参数包含非法字符:"+trimStr);
            }
        }

    }

}
