package com.aote.timer;

import com.aote.logic.LogicServer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public class TaskJob {

	@Autowired
	private LogicServer logicServer;

	private List<ISource> sources;
	private CommonTarget commonTarget;
	private CommonCallBack commonCallBack;

	@SuppressWarnings("unchecked")
	public void run() {
		long startTime = System.currentTimeMillis();
		if (sources.size() > 0) {
			for (ISource source : sources) {
				List<JSONArray> list = (List<JSONArray>) source.getSource();
				if (list != null && list.size() > 0) {
					List<JSONArray> resultList;
					list.size();
					if (commonTarget == null) {
						commonCallBack.runCallBack(list);
					} else {
						resultList = commonTarget.sendTarget(list);
						if (resultList != null) {
							commonCallBack.runCallBack(resultList);
						}
					}
				}
			}
		}
		long endTime = System.currentTimeMillis();
		logicServer.debug("run()方法本次耗时" + ((endTime - startTime) + "毫秒"));
	}

	public void runLogic(){
		List<String> logics = commonCallBack.getLogics();
		for (String logic : logics) {
			try {
				logicServer.run(logic, new JSONObject());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public List<ISource> getSources() {
		return sources;
	}

	public void setSources(List<ISource> sources) {
		this.sources = sources;
	}

	public void setCommonTarget(CommonTarget commonTarget) {
		this.commonTarget = commonTarget;
	}

	public void setCommonCallBack(CommonCallBack commonCallBack) {
		this.commonCallBack = commonCallBack;
	}

}
