package com.aote.rs;

import com.aote.ThreadResource;
import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import java.io.*;
import java.net.URL;


@Path("vue")
@Singleton
@Component
public class VueService {
    /**
     * 执行业务逻辑(GET方式)
     *
     * @param  vueName 业务逻辑名称
     * @return 执行结果
     */
    @GET
    @Transactional
    @Path("{vue}")
    public String getVueConfig(@PathParam("vue") String vueName)throws Exception {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            // 把文件不存在异常转换成704错误状态
            throw new WebException(704, "用户没有特殊目录！");
        }
        //查看对应目录下是否存在相关vue
        String path =dir + "/vues/" +vueName;
        try {
            return ResourceHelper.getString(path);
        } catch (FileNotFoundException e) {
            // 把文件不存在异常转换成704错误状态
            throw new WebException(704, "文件不存在：" + e.getPath());
        }
    }

    @GET
    @Transactional
    public String getPhoneVueConfig() throws Exception{
        JSONObject jsons = new JSONObject();
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null || "".equals(dir)){
            throw new WebException(704, "用户没有特殊目录！");
        }
        try {
            //获取目录下所有文件名
            URL url = this.getClass().getClassLoader().getResource(dir +"/phonevues/");
            if (url == null) {
                url = this.getClass().getClassLoader().getResource("phonevues/");
            }
            String path = url.getPath();
            File[] files = new File(path).listFiles();
            for (File f :files){
                //读取文件内容
                String fileName = f.getName();
                StringBuffer strbuffer = new StringBuffer();
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader inputStreamReader = new InputStreamReader(fis, "UTF-8");
                BufferedReader in  = new BufferedReader(inputStreamReader);
                String str;
                while ((str = in.readLine()) != null) {
                    strbuffer.append(str);
                }
                in.close();
                //将文件内容转为json并保存
                JSONObject json = new JSONObject(strbuffer.toString().trim());
                jsons.put(fileName.substring(0,fileName.indexOf(".")),json);
            }
            return jsons.toString();
        }catch (FileNotFoundException e){
            throw new WebException(704, "文件不存在: "+e.getPath());
        }
    }
}
