package com.aote.queryparams;

import com.aote.ThreadResource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import javax.annotation.PostConstruct;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 查询参数映射器
 */
public class QueryParamsMapper {

	private static final Logger LOGGER = Logger.getLogger(QueryParamsMapper.class);

	private static Map<String, Map<String, String>> map;

	@PostConstruct
	public void init(){
		//初始化即加载
		loadMap();
	}

	public static String getQueryParams(String alias)
	{
		if(map.containsKey(alias)) {
			String result = getQueryParamsByUser(alias);
			if(result != null) {
				return result;
			}
			return map.get(alias).get("path");
		}
		else {
            return null;
        }
	}

	public static Map<String, Map<String, String>> getMap() {
		return QueryParamsMapper.map;
	}

	public static String getQueryParamsByUser(String alias){
		//获取登陆用户用户名
		String dir = ThreadResource.ComponentDir.get();
		if (dir == null) {
			return null;
		}
		//查看对应目录下是否存在相关queryparams
		String path = dir + "/queryparams/" + alias + ".json";
		if (QueryParamsMapper.class.getResource(path) != null) {
			return path;
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		SAXReader reader = new SAXReader();
		InputStream module = QueryParamsMapper.class.getClassLoader().getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = QueryParamsMapper.class.getClassLoader().getResourceAsStream("queryparams.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator<Element> item = root.elementIterator("queryparams"); item.hasNext();) {
					Element element = item.next();
					setQueryParamsRes(element, null, null);
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator<Element> it = root.elementIterator("module"); it.hasNext();) {
			Element elm = it.next();
			String name = elm.attribute("name").getValue();
			String path = elm.attributeValue("path");
			putMap(name, reader, path);
		}
	}

	private static void putMap(String name, SAXReader reader, String parent) throws Exception {
		String str = parent == null ? name + "/queryparams.xml" : parent+"/"+name + "/queryparams.xml";
		InputStream module = QueryParamsMapper.class.getClassLoader().getResourceAsStream(str);
		if (module != null) {
			Document doc = reader.read(module);
			Element root = doc.getRootElement();
			for (Iterator<Element> item = root.elementIterator("queryparams"); item.hasNext();) {
				Element element = item.next();
				setQueryParamsRes(element, name, parent);
			}
		}
	}

	private static void setQueryParamsRes(Element element, String moduleName, String moduleParent) throws Exception {
		String aliasSql = element.attribute("alias").getValue();
		String pathSql = element.attribute("path").getValue();
		String mobile = element.attributeValue("mobile");

		// 验证别名是否重复
		if (map.containsKey(aliasSql)){
			throw new Exception("QueryParams别名"+ aliasSql + "已存在");
		}

		String path;

		if(moduleName == null){
			path = "queryparams/" + pathSql;
		} else {
			path = (moduleParent == null ? moduleName + "/queryparams/" : moduleParent + "/" + moduleName + "/queryparams/") + pathSql;
		}
		// 设置SQL属性
		Map<String, String> sql = new HashMap<>();
		sql.put("alias", aliasSql);
		sql.put("path", path);
		sql.put("mobile", mobile);
		map.put(aliasSql, sql);
	}
}
