/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.exception.ExceptionLogManage;
import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.mq.RocketMQProducer;
import com.aote.rs.mapper.WebException;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.message.Message;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    @Autowired
    private SessionPool sessionPool;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    @Qualifier(value="rocketMQProducer")
    private RocketMQProducer producer;
    @Autowired
    private ExceptionLogManage exceptionLogManage;

    @GET
    @Path(value="/clear")
    public String clearLogicCache() {
        ResourceHelper.clearLogicCache();
        return "ok";
    }

    @GET
    @Path(value="/clearall")
    public String clearAllCache() {
        ResourceHelper.clearLogicCache();
        ResourceHelper.clearSqlCache();
        ResourceHelper.clearPathCache();
        ResourceHelper.clearQueryParamsCache();
        return "ok";
    }

    @GET
    @Transactional
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.xtSave(logicName, params.toString(), request);
    }

    @POST
    @Transactional
    @Path(value="{logic}")
    public Response xtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) {
        JSONObject paramJson;
        log.info((Object)("logic:" + logicName + ", values:" + values));
        values = this.getValues(values, request);
        String result = this.run(logicName, values);
        Response.ResponseBuilder builder = Response.ok();
        if (result.startsWith("{") && (paramJson = new JSONObject(result)).has("header") && paramJson.has("content")) {
            Map paramHeader = paramJson.getJSONObject("header").toMap();
            for (Map.Entry stringObjectEntry : paramHeader.entrySet()) {
                builder.header((String)stringObjectEntry.getKey(), (Object)String.valueOf(stringObjectEntry.getValue()));
            }
            return builder.type("text/plain").entity((Object)String.valueOf(paramJson.get("content"))).build();
        }
        return builder.entity((Object)result).build();
    }

    @GET
    @Transactional
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.mqXtSave(logicName, params.toString(), request);
    }

    @POST
    @Transactional
    @Path(value="mq/{logic}")
    public Response mqXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        log.info((Object)("logic:" + logicName + ", values:" + values));
        values = this.getValues(values, request);
        Message msg = new Message("logic", logicName, values.getBytes(StandardCharsets.UTF_8));
        this.producer.getDefaultMQProducer().sendOneway(msg);
        return Response.ok().build();
    }

    @GET
    @Transactional
    @Async(value="AsyncLogicGet")
    @Path(value="async/{logic}")
    public Response asyncXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        this.xtSave(logicName, params.toString(), request);
        return Response.noContent().build();
    }

    @POST
    @Async(value="AsyncLogicPost")
    @Transactional
    @Path(value="async/{logic}")
    public void asyncXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        this.xtSave(logicName, values, request);
    }

    @GET
    @Transactional
    @Path(value="debug/{logic}")
    public Response debugXtSave(@PathParam(value="logic") String logicName, @Context HttpServletRequest request) throws Exception {
        Map paramMap = request.getParameterMap();
        JSONObject params = new JSONObject(paramMap);
        return this.debugXtSave(logicName, params.toString(), request);
    }

    @POST
    @Transactional
    @Path(value="debug/{logic}")
    public Response debugXtSave(@PathParam(value="logic") String logicName, String values, @Context HttpServletRequest request) throws Exception {
        Response result = this.xtSave(logicName, values, request);
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        return result;
    }

    @Transactional
    public String xtSave(String logicName, String values) {
        return this.xtSave(logicName, values, null).getEntity().toString();
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = headerNames.nextElement().toString();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    private String run(String logicName, String values) {
        try {
            Object result = this.logicServer.run(logicName, values);
            if (result == null) {
                return "";
            }
            if (result instanceof Map) {
                JSONObject json = new JSONObject((Map)result);
                return json.toString();
            }
            if (result instanceof JSONObject) {
                JSONObject json = (JSONObject)result;
                return json.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            String stack = ExceptionLogManage.getErrorInfo(ExceptionHelper.stackToString(ex), 1);
            log.error((Object)stack);
            String path = LogicMapper.getLogic(logicName);
            if (path == null) {
                path = logicName;
            }
            this.exceptionLogManage.writeError(ex, path, "/rs/logic/" + logicName);
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }

    @PostConstruct
    public void redisCacheLogic() throws Exception {
        this.logicServer.redisCacheLogic();
    }
}

