/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsServer;
import com.aote.util.ResourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class ResourceHelper {
    public static String mode = "normal";
    private static final ConcurrentHashMap<String, String> CACHE_LOGIC_MAP = new ConcurrentHashMap(10);
    private static final ConcurrentHashMap<String, String> CACHE_SQL_MAP = new ConcurrentHashMap(10);
    private static final ConcurrentHashMap<String, String> CACHE_PATH_MAP = new ConcurrentHashMap(10);
    private static final ConcurrentHashMap<String, JSONObject> CACHE_QUERY_PARAMS_MAP = new ConcurrentHashMap(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String fileName) throws FileNotFoundException, IOException {
        String result;
        InputStream inputStream = null;
        BufferedReader br = null;
        try {
            String line;
            if (!fileName.startsWith("/")) {
                fileName = "/" + fileName;
            }
            if (null == (inputStream = ResourceHelper.class.getResourceAsStream(fileName))) {
                throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
            }
            br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            result = sb.toString();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    public static Object getString(ResourceType resourceType, String alias, String fileName) throws FileNotFoundException, IOException {
        String source;
        switch (resourceType) {
            case LOGIC: {
                if (!mode.equals("debug") && CACHE_LOGIC_MAP.containsKey(alias)) {
                    return CACHE_LOGIC_MAP.get(alias);
                }
                String sourceStr = ResourceHelper.getString(fileName);
                sourceStr = sourceStr.replace("\r\n", "\n");
                return sourceStr;
            }
            case SQL: {
                if (!mode.equals("debug") && CACHE_SQL_MAP.containsKey(alias)) {
                    source = CACHE_SQL_MAP.get(alias);
                    break;
                }
                source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                CACHE_SQL_MAP.put(alias, source);
                break;
            }
            case PATH: {
                if (!mode.equals("debug") && CACHE_PATH_MAP.containsKey(alias)) {
                    source = CACHE_PATH_MAP.get(alias);
                    break;
                }
                source = ResourceHelper.getString(fileName);
                source = source.replace("\r\n", "\n");
                source = "$" + source;
                CACHE_PATH_MAP.put(alias, source);
                break;
            }
            case QUERY_PARAMS: {
                if (!mode.equals("debug") && CACHE_QUERY_PARAMS_MAP.containsKey(alias)) {
                    return CACHE_QUERY_PARAMS_MAP.get(alias);
                }
                String source2 = ResourceHelper.getString(fileName);
                JSONObject result = QueryParamsServer.getQueryParamsInfo(source2);
                CACHE_QUERY_PARAMS_MAP.put(alias, result);
                return result;
            }
            default: {
                throw new RuntimeException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
            }
        }
        return source;
    }

    public static void clearLogicCache() {
        CACHE_LOGIC_MAP.clear();
    }

    public static void clearSqlCache() {
        CACHE_SQL_MAP.clear();
    }

    public static void clearPathCache() {
        CACHE_PATH_MAP.clear();
    }
}

