/*
 * Decompiled with CFR 0.152.
 */
package com.aote.queryparams;

import com.aote.exception.FileNotFoundException;
import com.aote.queryparams.QueryParamsMapper;
import com.aote.queryparams.QueryTypeEnum;
import com.aote.rs.mapper.WebException;
import com.aote.util.ResourceHelper;
import com.aote.util.ResourceType;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class QueryParamsServer {
    public static JSONObject getQuerySQL(String queryParamsName, JSONObject params) throws Exception {
        JSONObject queryParamsMap;
        String path = QueryParamsMapper.getQueryParams(queryParamsName);
        if (path == null) {
            throw new RuntimeException("\u67e5\u8be2\u53c2\u6570\u6587\u4ef6\u672a\u627e\u5230: " + queryParamsName);
        }
        try {
            queryParamsMap = (JSONObject)ResourceHelper.getString(ResourceType.QUERY_PARAMS, queryParamsName, path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        String tableAliasName = queryParamsMap.getString("tableAliasName");
        StringBuilder querySql = (StringBuilder)queryParamsMap.get("querySql");
        StringBuilder countSql = (StringBuilder)queryParamsMap.get("countSql");
        JSONObject joinTableNameObject = queryParamsMap.getJSONObject("joinTableNameObject");
        JSONObject canJoinTableNameObject = queryParamsMap.getJSONObject("canJoinTableNameObject");
        String orderBy = queryParamsMap.getString("orderBy");
        String whereCondition = QueryParamsServer.getValue(queryParamsMap.getJSONObject("selectColumn"), params, tableAliasName, joinTableNameObject, canJoinTableNameObject);
        Iterator canJoinTableIterator = canJoinTableNameObject.keys();
        while (canJoinTableIterator.hasNext()) {
            JSONObject joinObject = canJoinTableNameObject.getJSONObject((String)canJoinTableIterator.next());
            String condition = joinObject.getString("value");
            querySql.append("\n\t").append(condition);
            String source = joinObject.getString("source");
            if (!source.equals("\u67e5\u8be2\u6761\u4ef6") && !source.equals("\u5c55\u793a\u5217/\u67e5\u8be2\u6761\u4ef6")) continue;
            countSql.append("\n\t").append(condition);
        }
        querySql.append("\n").append("WHERE").append(whereCondition);
        countSql.append("\n").append("WHERE").append(whereCondition);
        querySql.append("\nORDER BY ").append(orderBy);
        JSONObject result = new JSONObject();
        result.put("querySql", (Object)querySql.toString());
        result.put("countSql", (Object)countSql.toString());
        return result;
    }

    public static JSONObject getSignleStyleQuerySQL(String queryParamsName, JSONObject params) throws Exception {
        JSONObject queryParams = QueryParamsServer.getQuerySQL(queryParamsName, params);
        String querySql = queryParams.getString("querySql");
        String countSql = queryParams.getString("countSql");
        JSONObject result = new JSONObject();
        result.put("items", (Object)querySql.substring(querySql.indexOf("SELECT") + 6, querySql.indexOf("FROM")));
        result.put("tableName", (Object)querySql.substring(querySql.indexOf("FROM") + 4, querySql.indexOf("WHERE")));
        result.put("condition", (Object)querySql.substring(querySql.indexOf("WHERE") + 5));
        result.put("countItems", (Object)countSql.substring(countSql.indexOf("SELECT") + 6, countSql.indexOf("FROM")));
        result.put("countTableName", (Object)countSql.substring(countSql.indexOf("FROM") + 4, countSql.indexOf("WHERE")));
        result.put("countCondition", (Object)countSql.substring(countSql.indexOf("WHERE") + 5));
        result.put("querySql", (Object)querySql);
        result.put("countSql", (Object)countSql);
        return result;
    }

    public static String getValue(JSONObject queryMap, JSONObject params, String tableAliasName, JSONObject joinTableNameObject, JSONObject canJoinTableNameObject) throws Exception {
        Iterator iterator = params.keys();
        StringBuilder condition = new StringBuilder(" 1=1");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(params.get(key));
            if (value.length() == 0 || value.equals("\u5168\u90e8")) continue;
            if (queryMap.has(key)) {
                JSONObject queryParams = queryMap.getJSONObject(key);
                if (!queryParams.has("queryType")) {
                    throw new RuntimeException("\u67e5\u8be2\u5b57\u6bb5[" + key + "] \u6ca1\u6709\u5bf9\u5e94\u7684queryType\u4fe1\u606f");
                }
                QueryTypeEnum queryType = QueryTypeEnum.toType(queryParams.getString("queryType"));
                String realKey = queryParams.getString("key");
                switch (queryType) {
                    case EQUALS: 
                    case NO_EQUALS: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUALS: {
                        condition.append("\n\tAND ").append(realKey).append(" ").append(queryType.getValue()).append(" '").append(value).append("'");
                        break;
                    }
                    case INNER_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                        break;
                    }
                    case LEFT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("'");
                        break;
                    }
                    case RIGHT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '").append(value).append("%'");
                        break;
                    }
                    case IN: {
                        condition.append("\n\tAND ").append(realKey).append(" IN (").append(value).append(")");
                        break;
                    }
                    case NOT_IN: {
                        condition.append("\n\tAND ").append(realKey).append(" NOT IN (").append(value).append(")");
                        break;
                    }
                    case BETWEEN: {
                        String[] values = StringUtils.split((String)value.substring(1, value.length() - 1), (String)",");
                        condition.append("\n\tAND ").append(realKey).append(" BETWEEN '").append(values[0]).append("' AND '").append(values[1]).append("'");
                    }
                }
                QueryParamsServer.putJoinCondition(realKey, tableAliasName, joinTableNameObject, canJoinTableNameObject, "\u67e5\u8be2\u6761\u4ef6");
                continue;
            }
            throw new WebException(500, "\u751f\u6210\u67e5\u8be2\u6761\u4ef6\u65f6\uff0c\u7f3a\u5c11\u8868\u5355\u5b57\u6bb5'" + key + "'\u7684\u914d\u7f6e");
        }
        return condition.toString();
    }

    public static JSONObject getQueryParamsInfo(String source) {
        JSONObject realQueryParamsMap = new JSONObject(source);
        JSONArray queryParamsArray = realQueryParamsMap.getJSONArray("column");
        JSONObject selectColumnArray = new JSONObject();
        for (Object item : queryParamsArray) {
            JSONObject columnItem = (JSONObject)item;
            String key = columnItem.getString("key");
            int index = key.indexOf(46);
            index = index == -1 ? 0 : ++index;
            String realKey = key.substring(index);
            columnItem.put("dataIndex", (Object)realKey);
            selectColumnArray.put(realKey, (Object)columnItem);
        }
        realQueryParamsMap.put("column", (Object)queryParamsArray);
        StringBuilder sql = new StringBuilder("SELECT ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0) n");
        String tableName = realQueryParamsMap.getString("tableName");
        String tableAliasName = tableName.substring(tableName.indexOf(32) + 1);
        JSONObject joinTableNameObject = realQueryParamsMap.getJSONObject("joinArray");
        JSONObject canJoinTableNameObject = new JSONObject();
        JSONArray queryColumnArray = realQueryParamsMap.getJSONArray("column");
        JSONArray showColumnArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            if (!column.has("title")) continue;
            JSONObject item = new JSONObject();
            item.put("title", (Object)column.getString("title"));
            item.put("dataIndex", (Object)column.getString("dataIndex"));
            if (column.has("width")) {
                item.put("width", (Object)column.getString("width"));
            }
            if (column.has("scopedSlots")) {
                item.put("scopedSlots", (Object)column.getJSONObject("scopedSlots"));
            }
            showColumnArray.put((Object)item);
            if (key.equals("action")) continue;
            sql.append("\n\t").append(key).append(",");
            QueryParamsServer.putJoinCondition(key, tableAliasName, joinTableNameObject, canJoinTableNameObject, "\u5c55\u793a\u5217");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append("\n").append("FROM ").append(tableName);
        countSql.append("\n").append("FROM ").append(tableName);
        JSONObject result = new JSONObject();
        result.put("tableAliasName", (Object)tableAliasName);
        result.put("countSql", (Object)countSql);
        result.put("querySql", (Object)sql);
        result.put("joinTableNameObject", (Object)joinTableNameObject);
        result.put("canJoinTableNameObject", (Object)canJoinTableNameObject);
        result.put("selectColumn", (Object)selectColumnArray);
        result.put("orderBy", (Object)realQueryParamsMap.getString("orderBy"));
        result.put("columnJson", (Object)showColumnArray);
        return result;
    }

    public static void putJoinCondition(String dataKey, String tableAliasName, JSONObject joinTableNameObject, JSONObject canJoinTableNameObject, String source) {
        String joinTableAlias = dataKey.substring(0, dataKey.indexOf(46));
        if (joinTableAlias.equals(tableAliasName)) {
            return;
        }
        if (joinTableNameObject.has(joinTableAlias)) {
            if (!canJoinTableNameObject.has(joinTableAlias)) {
                String joinCondition = joinTableNameObject.getString(joinTableAlias);
                JSONObject params = new JSONObject();
                params.put("source", (Object)source);
                params.put("value", (Object)("LEFT JOIN " + joinCondition));
                canJoinTableNameObject.put(joinTableAlias, (Object)params);
            } else if (source.equals("\u67e5\u8be2\u6761\u4ef6")) {
                canJoinTableNameObject.getJSONObject(joinTableAlias).put("source", (Object)"\u5c55\u793a\u5217/\u67e5\u8be2\u6761\u4ef6");
            }
        } else {
            throw new RuntimeException("\u6570\u636e\u5217[" + dataKey + "] \u6ca1\u6709\u5bf9\u5e94\u7684JOIN\u8868\u4fe1\u606f");
        }
    }
}

